/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.api.impl;

import com.buuz135.sushigocrafting.SushiGoCrafting;
import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IFoodType;
import com.buuz135.sushigocrafting.item.FoodItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.item.Item;

public class FoodHelper {
    public static HashMap<String, List<FoodItem>> REGISTERED = new LinkedHashMap<String, List<FoodItem>>();

    public static List<FoodItem> generateFood(IFoodType type) {
        ArrayList<FoodItem> items = new ArrayList<FoodItem>();
        items.addAll(FoodHelper.generate(type, type.getFoodIngredients()));
        REGISTERED.put(type.getName(), items);
        return items;
    }

    private static List<FoodItem> generate(IFoodType type, List<IFoodIngredient[]> foodIngredients) {
        ArrayList<FoodItem> items = new ArrayList<FoodItem>();
        if (foodIngredients.size() == 1) {
            for (IFoodIngredient iFoodIngredient : foodIngredients.get(0)) {
                FoodItem item = new FoodItem(new Item.Properties().func_200916_a(SushiGoCrafting.TAB), type);
                item.getIngredientList().add(iFoodIngredient);
                items.add(item);
            }
        } else {
            for (IFoodIngredient iFoodIngredient : foodIngredients.get(0)) {
                List<FoodItem> all = FoodHelper.generate(type, foodIngredients.subList(1, foodIngredients.size()));
                for (FoodItem item : all) {
                    if (item == null) continue;
                    item.getIngredientList().add(0, iFoodIngredient);
                }
                items.addAll(all);
            }
        }
        return items;
    }

    public static String getName(FoodItem item) {
        ArrayList<String> names = new ArrayList<String>();
        for (int nameIndex : item.getType().getNameIndex()) {
            if (item.getIngredientList().get(nameIndex).isEmpty()) continue;
            names.add(item.getIngredientList().get(nameIndex).getName());
        }
        names.add(item.getType().getName());
        return String.join((CharSequence)"_", names);
    }

    public static FoodItem getFoodFromIngredients(String type, List<IFoodIngredient> foodIngredients) {
        for (FoodItem foodItem : REGISTERED.get(type)) {
            if (foodIngredients.size() != foodItem.getIngredientList().size()) continue;
            boolean allMatch = true;
            for (int i = 0; i < foodIngredients.size(); ++i) {
                if (foodIngredients.get(i).equals(foodItem.getIngredientList().get(i))) continue;
                allMatch = false;
            }
            if (!allMatch) continue;
            return foodItem;
        }
        return null;
    }
}

