/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.item;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.item.SushiItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class AmountItem
extends SushiItem {
    public static final String NBT_AMOUNT = "Amount";
    private final int minAmount;
    private final int maxAmount;
    private final int maxCombineAmount;

    public AmountItem(Item.Properties properties, String category, int minAmount, int maxAmount, int maxCombineAmount, boolean foodHurts) {
        super(properties.func_221540_a(new Food.Builder().func_221456_a(2).func_221454_a(0.3f).func_221452_a(new EffectInstance(Effects.field_76436_u, 100, 0), foodHurts ? 0.6f : 0.01f).func_221453_d()), category);
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.maxCombineAmount = maxCombineAmount;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        if (!stack.func_77942_o()) {
            stack.func_196082_o().func_74768_a(NBT_AMOUNT, worldIn.field_73012_v.nextInt(this.maxAmount - this.minAmount) + this.minAmount);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_AMOUNT);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)stack.func_196082_o().func_74762_e(NBT_AMOUNT) / (double)this.maxCombineAmount;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Color.YELLOW.getRGB();
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o()) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Amount: " + stack.func_77978_p().func_74762_e(NBT_AMOUNT) + "/" + this.maxCombineAmount + " gr."));
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            stack.func_196082_o().func_74768_a(NBT_AMOUNT, this.maxAmount / 2);
            items.add((Object)stack);
        }
    }

    public int getCurrentAmount(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(NBT_AMOUNT);
    }

    public int getMinAmount() {
        return this.minAmount;
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public int getMaxCombineAmount() {
        return this.maxCombineAmount;
    }

    public ItemStack withAmount(int amount) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        stack.func_196082_o().func_74768_a(NBT_AMOUNT, amount);
        return stack;
    }

    public ItemStack random(PlayerEntity entity, World world) {
        int extra = 0;
        if (entity != null && entity.func_70644_a((Effect)SushiContent.Effects.STEADY_HANDS.get())) {
            extra += (entity.func_70660_b((Effect)SushiContent.Effects.STEADY_HANDS.get()).func_76458_c() + 1) * this.getMinAmount();
        }
        return this.withAmount(Math.min(this.getMaxCombineAmount(), extra + world.field_73012_v.nextInt(this.getMaxAmount() - this.getMinAmount()) + this.getMinAmount()));
    }

    public void consume(IFoodIngredient ingredient, ItemStack stack, int amountLevel) {
        int amount = (int)((double)stack.func_196082_o().func_74762_e(NBT_AMOUNT) - (double)(ingredient.getDefaultAmount() * (amountLevel + 1)) / 5.0);
        stack.func_196082_o().func_74768_a(NBT_AMOUNT, amount);
        if (amount <= 0) {
            stack.func_190918_g(1);
        }
    }

    public boolean canConsume(IFoodIngredient ingredient, ItemStack stack, int amountLevel) {
        int amount = (int)((double)(ingredient.getDefaultAmount() * (amountLevel + 1)) / 5.0);
        return !stack.func_190926_b() && stack.func_196082_o().func_74762_e(NBT_AMOUNT) >= amount;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity) {
            worldIn.func_184148_a((PlayerEntity)null, entityLiving.func_226277_ct_(), entityLiving.func_226278_cu_(), entityLiving.func_226281_cx_(), this.func_225519_S__(), SoundCategory.NEUTRAL, 1.0f, 1.0f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.4f);
            ((PlayerEntity)entityLiving).func_71024_bL().func_75122_a(stack.func_77973_b().func_219967_s().func_221466_a(), stack.func_77973_b().func_219967_s().func_221469_b());
            for (Pair pair : stack.func_77973_b().func_219967_s().func_221464_f()) {
                if (worldIn.field_72995_K || pair.getFirst() == null || !(worldIn.field_73012_v.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                entityLiving.func_195064_c(new EffectInstance((EffectInstance)pair.getFirst()));
            }
            if (!((PlayerEntity)entityLiving).field_71075_bZ.field_75098_d) {
                this.consume(FoodAPI.get().getIngredientFromItem(this), stack, 6);
            }
        }
        return stack;
    }
}

