/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.loot;

import com.buuz135.sushigocrafting.loot.ItemWeightedItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class SeedsLootModifier
extends LootModifier {
    private List<ItemWeightedItem> seeds = new ArrayList<ItemWeightedItem>();

    public SeedsLootModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
        this.seeds.add(new ItemWeightedItem(Items.field_151014_N, 150));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.RICE_SEEDS.get(), 25));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.SESAME_SEEDS.get(), 10));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.WASABI_SEEDS.get(), 25));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.SOY_SEEDS.get(), 25));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.CUCUMBER_SEEDS.get(), 25));
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ArrayList<ItemStack> customLoot = new ArrayList<ItemStack>();
        for (ItemStack stack : generatedLoot) {
            if (stack.func_77973_b() == Items.field_151014_N) {
                ItemWeightedItem weightedItem = (ItemWeightedItem)WeightedRandom.func_76271_a((Random)context.func_216032_b(), this.seeds);
                ItemStack weightedStack = new ItemStack((IItemProvider)weightedItem.getStack());
                weightedStack.func_190920_e(stack.func_190916_E());
                customLoot.add(weightedStack);
                continue;
            }
            customLoot.add(stack);
        }
        return customLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<SeedsLootModifier> {
        public SeedsLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            return new SeedsLootModifier(ailootcondition);
        }

        public JsonObject write(SeedsLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

