/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.tile.machinery;

import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.buuz135.sushigocrafting.recipe.FermentingBarrelRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.util.RecipeUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FermentationBarrelTile
extends ActiveTile<FermentationBarrelTile> {
    @Save
    private ProgressBarComponent<FermentationBarrelTile> bar = new ProgressBarComponent(93, 48, 100).setCanIncrease(FermentationBarrelTile::canStart).setCanReset(FermentationBarrelTile::canStart).setOnTickWork(() -> this.syncObject(this.bar)).setBarDirection(ProgressBarComponent.BarDirection.ARROW_RIGHT).setOnFinishWork(() -> {
        this.onFinish();
        this.syncObject(this.bar);
        this.func_70296_d();
    });
    @Save
    private FluidTankComponent<FermentationBarrelTile> fluid;
    @Save
    private InventoryComponent<FermentationBarrelTile> input;
    @Save
    private InventoryComponent<FermentationBarrelTile> output;

    public FermentationBarrelTile() {
        super((BasicTileBlock)SushiContent.Blocks.FERMENTATION_BARREL.get());
        this.addProgressBar(this.bar);
        this.input = new InventoryComponent("input", 30, 48, 1).setSlotToColorRender(0, DyeColor.BLUE).setOutputFilter((i, s) -> false);
        this.addInventory(this.input);
        this.output = new InventoryComponent("output", 130, 48, 1).setSlotToColorRender(0, DyeColor.ORANGE).setInputFilter((i, s) -> false);
        this.addInventory(this.output);
        this.fluid = new FluidTankComponent("fluid", 2000, 59, 46).setTankType(FluidTankComponent.Type.SMALL).setTankAction(FluidTankComponent.Action.FILL);
        this.addTank(this.fluid);
    }

    @Nonnull
    public FermentationBarrelTile getSelf() {
        return this;
    }

    public ActionResultType onActivated(PlayerEntity player, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        ActionResultType type = super.onActivated(player, hand, facing, hitX, hitY, hitZ);
        if (!type.func_226247_b_()) {
            this.openGui(player);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public boolean canStart() {
        return RecipeUtil.getRecipes((World)this.field_145850_b, (IRecipeType)FermentingBarrelRecipe.SERIALIZER.getRecipeType()).stream().anyMatch(fermentingBarrelRecipe -> fermentingBarrelRecipe.input.test(this.input.getStackInSlot(0)) && (fermentingBarrelRecipe.fluid.isEmpty() || fermentingBarrelRecipe.fluid.isFluidEqual(this.fluid.getFluid()) && this.fluid.getFluid().getAmount() >= fermentingBarrelRecipe.fluid.getAmount()) && this.output.getStackInSlot(0).func_190926_b());
    }

    public void onFinish() {
        RecipeUtil.getRecipes((World)this.field_145850_b, (IRecipeType)FermentingBarrelRecipe.SERIALIZER.getRecipeType()).stream().filter(fermentingBarrelRecipe -> fermentingBarrelRecipe.input.test(this.input.getStackInSlot(0)) && (fermentingBarrelRecipe.fluid.isEmpty() || fermentingBarrelRecipe.fluid.isFluidEqual(this.fluid.getFluid()) && this.fluid.getFluid().getAmount() >= fermentingBarrelRecipe.fluid.getAmount()) && this.output.getStackInSlot(0).func_190926_b()).findFirst().ifPresent(fermentingBarrelRecipe -> {
            this.input.getStackInSlot(0).func_190918_g(1);
            this.fluid.drainForced(fermentingBarrelRecipe.getFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            if (fermentingBarrelRecipe.output.func_77973_b() instanceof AmountItem) {
                ItemHandlerHelper.insertItem(this.output, (ItemStack)((AmountItem)fermentingBarrelRecipe.output.func_77973_b()).random(null, this.field_145850_b), (boolean)false);
            } else {
                ItemHandlerHelper.insertItem(this.output, (ItemStack)fermentingBarrelRecipe.output.func_77946_l(), (boolean)false);
            }
        });
    }

    public ProgressBarComponent<FermentationBarrelTile> getBar() {
        return this.bar;
    }
}

