/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.material;

import com.google.gson.JsonObject;
import com.hrznstudio.titanium.api.material.IHasColor;
import com.hrznstudio.titanium.api.material.IResourceHolder;
import com.hrznstudio.titanium.api.material.IResourceType;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.material.IAdvancedResourceType;
import com.hrznstudio.titanium.material.ResourceMaterial;
import com.hrznstudio.titanium.material.ResourceTypeProperties;
import com.hrznstudio.titanium.recipe.generator.IJSONGenerator;
import com.hrznstudio.titanium.recipe.generator.IJsonFile;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class ResourceTypeItem
extends BasicItem
implements IJsonFile,
IJSONGenerator,
IResourceHolder,
IHasColor {
    private final ResourceMaterial material;
    private final IResourceType type;
    private final IAdvancedResourceType advancedResourceType;

    public ResourceTypeItem(ResourceMaterial material, IResourceType type, IAdvancedResourceType advancedResourceType, ResourceTypeProperties<Item.Properties> properties) {
        super(material.getMaterialType() + "_" + type.func_176610_l(), properties == null ? (Item.Properties)ResourceTypeProperties.DEFAULTS.get(Item.class).get() : properties.get());
        this.material = material;
        this.type = type;
        this.advancedResourceType = advancedResourceType;
    }

    @Override
    public ResourceMaterial getMaterial() {
        return this.material;
    }

    @Override
    public IResourceType getType() {
        return this.type;
    }

    @Override
    public JsonObject generate() {
        return this.advancedResourceType.generate(this.type);
    }

    @Override
    public String getRecipeKey() {
        return this.getRegistryName().func_110623_a();
    }

    @Override
    @Nullable
    public String getRecipeSubfolder() {
        return "assets/titanium/models/item/";
    }

    @Override
    public int getColor(int tintIndex) {
        return this.advancedResourceType.getColor(this.material, tintIndex);
    }

    public ITextComponent func_200295_i(ItemStack p_200295_1_) {
        return this.type.getTextComponent(this.material.getTextComponent());
    }
}

