/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.network;

import com.hrznstudio.titanium.network.Message;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    private SimpleChannel network;
    private int i = 0;

    public NetworkHandler(String modid) {
        this.network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(modid, "network"), () -> "1.0", s -> true, s -> true);
    }

    public SimpleChannel get() {
        return this.network;
    }

    public <REQ extends Message> void registerMessage(Class<REQ> message) {
        this.network.registerMessage(this.i++, message, Message::toBytes, buffer -> {
            try {
                Message req = (Message)message.getConstructor(new Class[0]).newInstance(new Object[0]);
                req.fromBytes((PacketBuffer)buffer);
                return req;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }, (req, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            req.handleMessage(context);
            context.setPacketHandled(true);
        });
    }

    public void sendToNearby(World world, BlockPos pos, int distance, Message message) {
        world.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(pos).func_186662_g((double)distance)).forEach(playerEntity -> this.network.sendTo((Object)message, playerEntity.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT));
    }
}

