/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.api.impl;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IFoodType;
import com.buuz135.sushigocrafting.api.impl.FoodIngredient;
import com.buuz135.sushigocrafting.api.impl.FoodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;

public class FoodAPI {
    private static FoodAPI INSTACE = new FoodAPI();
    private List<IFoodType> foodTypes = new ArrayList<IFoodType>();
    private List<IFoodIngredient> foodIngredients = new ArrayList<IFoodIngredient>();

    private FoodAPI() {
    }

    public FoodAPI init() {
        FoodIngredient.init();
        FoodType.init();
        return this;
    }

    public static FoodAPI get() {
        return INSTACE;
    }

    public void addFoodIngredient(IFoodIngredient iFoodIngredient) {
        this.foodIngredients.add(iFoodIngredient);
    }

    public void addFoodType(IFoodType iFoodType) {
        this.foodTypes.add(iFoodType);
    }

    @Nonnull
    public IFoodIngredient getIngredientFromItem(Item item) {
        for (IFoodIngredient value : this.foodIngredients) {
            if (value.isEmpty() || !value.getItem().equals(item)) continue;
            return value;
        }
        return FoodIngredient.EMPTY;
    }

    @Nonnull
    public IFoodIngredient getIngredientFromName(String name) {
        for (IFoodIngredient value : this.foodIngredients) {
            if (!value.getName().equals(name)) continue;
            return value;
        }
        return FoodIngredient.EMPTY;
    }

    public List<IFoodType> getFoodTypes() {
        return Collections.unmodifiableList(this.foodTypes);
    }

    public List<IFoodIngredient> getFoodIngredient() {
        return Collections.unmodifiableList(this.foodIngredients);
    }

    public Optional<IFoodType> getTypeFromName(String name) {
        for (IFoodType foodType : this.foodTypes) {
            if (!foodType.getName().equalsIgnoreCase(name)) continue;
            return Optional.of(foodType);
        }
        return Optional.empty();
    }
}

