/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.client.gui;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IIngredientConsumer;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.cap.SushiWeightDiscoveryCapability;
import com.buuz135.sushigocrafting.client.gui.provider.SushiAssetTypes;
import com.buuz135.sushigocrafting.tile.machinery.RollerTile;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;

public abstract class RollerWeightSelectorButtonComponent
extends BasicScreenAddon
implements IClickable {
    private final InventoryComponent<RollerTile> inventoryComponent;
    private final int slot;

    public RollerWeightSelectorButtonComponent(InventoryComponent inventoryComponent, int slot) {
        super(0, 0);
        this.inventoryComponent = inventoryComponent;
        this.slot = slot;
    }

    public static void drawBackground(MatrixStack matrixStack, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int posX, int posY) {
        IAsset asset = iAssetProvider.getAsset(SushiAssetTypes.ROLLER_WEIGHT_PICKER_BG);
        if (asset != null) {
            AssetUtil.drawAsset((MatrixStack)matrixStack, (Screen)screen, (IAsset)asset, (int)(guiX + posX), (int)(guiY + posY));
        }
    }

    public static void drawForeground(MatrixStack matrixStack, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int posX, int posY, int weight, int ySize, String type, int slot) {
        IAsset asset = iAssetProvider.getAsset(SushiAssetTypes.ROLLER_WEIGHT_PICKER_POINTER);
        if (asset != null && weight != Integer.MIN_VALUE) {
            AssetUtil.drawAsset((MatrixStack)matrixStack, (Screen)screen, (IAsset)asset, (int)posX, (int)(posY + (4 - weight) * (ySize / 4) - 1));
        }
        Minecraft.func_71410_x().field_71439_g.getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(iSushiWeightDiscovery -> {
            if (iSushiWeightDiscovery.hasDiscovery(type + "-" + slot)) {
                int pos = posY + (4 - iSushiWeightDiscovery.getDiscovery(type + "-" + slot)) * (ySize / 4) - 1;
                AssetUtil.drawAsset((MatrixStack)matrixStack, (Screen)screen, (IAsset)iAssetProvider.getAsset(SushiAssetTypes.ROLLER_WEIGHT_PERFECT_POINTER), (int)(posX + 1), (int)(pos + 1));
            }
        });
    }

    public void drawBackgroundLayer(MatrixStack matrixStack, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int mouseX, int mouseY, float v) {
        RollerWeightSelectorButtonComponent.drawBackground(matrixStack, screen, iAssetProvider, guiX, guiY, this.getPosX(), this.getPosY());
    }

    public void drawForegroundLayer(MatrixStack matrixStack, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int mouseX, int mouseY) {
        RollerWeightSelectorButtonComponent.drawForeground(matrixStack, screen, iAssetProvider, guiX, guiY, this.getPosX(), this.getPosY(), this.getWeight(), this.getYSize(), this.getType(), this.slot);
    }

    public int getPosX() {
        return (Integer)((Pair)this.inventoryComponent.getSlotPosition().apply(this.slot)).getKey() + 17;
    }

    public int getPosY() {
        return (Integer)((Pair)this.inventoryComponent.getSlotPosition().apply(this.slot)).getValue() - 1;
    }

    public int getXSize() {
        return 4;
    }

    public int getYSize() {
        return 18;
    }

    public void handleClick(Screen screen, int guiX, int guiY, double mouseX, double mouseY, int button) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SimpleSound(SoundEvents.field_187887_gT, SoundCategory.PLAYERS, 0.5f, 1.0f, Minecraft.func_71410_x().field_71439_g.func_233580_cy_()));
        if (screen instanceof ContainerScreen && ((ContainerScreen)screen).func_212873_a_() instanceof ILocatable) {
            ILocatable locatable = (ILocatable)((ContainerScreen)screen).func_212873_a_();
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("WeightSlot", this.slot);
            nbt.func_74768_a("Button", button);
            Titanium.NETWORK.get().sendToServer((Object)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), 100, nbt));
        }
    }

    public List<ITextComponent> getTooltipLines() {
        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
        if (this.inventoryComponent.getStackInSlot(this.slot).func_190926_b()) {
            lines.add((ITextComponent)new StringTextComponent(NumberFormat.getInstance(Locale.getDefault()).format((double)(this.getWeight() + 1) / 5.0 * 100.0) + TextFormatting.DARK_AQUA + "%" + TextFormatting.GOLD + " Weight"));
        } else {
            IFoodIngredient ingredient = FoodAPI.get().getIngredientFromItem(this.inventoryComponent.getStackInSlot(this.slot).func_77973_b());
            if (!ingredient.isEmpty()) {
                String unit = ingredient.getIngredientConsumer() == IIngredientConsumer.STACK ? "u" : "gr";
                double amount = ingredient.getIngredientConsumer() == IIngredientConsumer.STACK ? (double)(ingredient.getDefaultAmount() * (this.getWeight() + 1)) : (double)(ingredient.getDefaultAmount() * (this.getWeight() + 1)) / 5.0;
                lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Consumes " + TextFormatting.WHITE + NumberFormat.getInstance(Locale.getDefault()).format(amount) + TextFormatting.YELLOW + unit));
            }
        }
        lines.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_GRAY + "*Left Click to Increase*"));
        lines.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_GRAY + "*Right Click to Decrease*"));
        return lines;
    }

    public abstract int getWeight();

    public abstract String getType();
}

