/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.tile.machinery;

import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.util.TagUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class RiceCookerTile
extends ActiveTile<RiceCookerTile> {
    public static ITag<Item> RICE = TagUtil.getItemTag((ResourceLocation)new ResourceLocation("forge", "crops/rice"));
    @Save
    private InventoryComponent<RiceCookerTile> input = new InventoryComponent("input", 20, 38, 4).setRange(2, 2).setSlotToColorRender(0, DyeColor.BLUE).setSlotToColorRender(1, DyeColor.BLUE).setSlotToColorRender(2, DyeColor.BLUE).setSlotToColorRender(3, DyeColor.BLUE).setSlotLimit(1).setInputFilter((stack, integer) -> stack.func_77973_b().func_206844_a(RICE)).setOutputFilter((stack, integer) -> false);
    @Save
    private ProgressBarComponent<RiceCookerTile> bar;
    @Save
    private InventoryComponent<RiceCookerTile> output;
    @Save
    private FluidTankComponent<RiceCookerTile> water;
    @Save
    private InventoryComponent<RiceCookerTile> fuel;
    @Save
    private double burnTime = 0.0;

    public RiceCookerTile() {
        super((BasicTileBlock)SushiContent.Blocks.RICE_COOKER.get());
        this.addInventory(this.input);
        this.bar = new ProgressBarComponent(99, 48, 100).setCanIncrease(RiceCookerTile::canStart).setCanReset(RiceCookerTile::canStart).setOnTickWork(() -> this.syncObject(this.bar)).setBarDirection(ProgressBarComponent.BarDirection.ARROW_RIGHT).setOnFinishWork(() -> {
            ItemStack result = ((AmountItem)SushiContent.Items.COOKED_RICE.get()).withAmount(this.getSlotsFilled() * 50);
            if (!this.output.getStackInSlot(0).func_190926_b()) {
                ItemStack original = this.output.getStackInSlot(0);
                result = ((AmountItem)SushiContent.Items.COOKED_RICE.get()).withAmount(Math.min(((AmountItem)original.func_77973_b()).getMaxCombineAmount(), ((AmountItem)original.func_77973_b()).getCurrentAmount(original) + ((AmountItem)result.func_77973_b()).getCurrentAmount(result)));
            }
            this.output.setStackInSlot(0, result);
            for (int i = 0; i < this.input.getSlots(); ++i) {
                this.input.setStackInSlot(i, ItemStack.field_190927_a);
            }
            this.water.drainForced(1000, IFluidHandler.FluidAction.EXECUTE);
            this.burnTime -= 1.0;
            this.syncObject(this.bar);
            this.func_70296_d();
        });
        this.addProgressBar(this.bar);
        this.output = new InventoryComponent("output", 134, 48, 1).setSlotToColorRender(0, DyeColor.ORANGE).setSlotLimit(1).setInputFilter((stack, integer) -> false).setOutputFilter((stack, integer) -> true);
        this.addInventory(this.output);
        this.water = (FluidTankComponent)new FluidTankComponent("water", 8000, 68, 27).setTankAction(FluidTankComponent.Action.FILL).setTankType(FluidTankComponent.Type.SMALL).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204546_a));
        this.addTank(this.water);
        this.fuel = new InventoryComponent("fuel", 69, 67, 1).setSlotToColorRender(0, DyeColor.RED).setSlotLimit(64).setInputFilter((stack, integer) -> ForgeHooks.getBurnTime((ItemStack)stack) > 0);
        this.addInventory(this.fuel);
    }

    @Nonnull
    public RiceCookerTile getSelf() {
        return this;
    }

    public ActionResultType onActivated(PlayerEntity player, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        ActionResultType type = super.onActivated(player, hand, facing, hitX, hitY, hitZ);
        if (!type.func_226247_b_()) {
            this.openGui(player);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public boolean canStart() {
        if (this.burnTime < 1.0 && !this.fuel.getStackInSlot(0).func_190926_b()) {
            this.burnTime += (double)ForgeHooks.getBurnTime((ItemStack)this.fuel.getStackInSlot(0)) / 200.0;
            this.fuel.getStackInSlot(0).func_190918_g(1);
            this.func_70296_d();
        }
        return this.burnTime > 0.0 && this.getSlotsFilled() > 0 && (this.output.getStackInSlot(0).func_190926_b() || ((AmountItem)this.output.getStackInSlot(0).func_77973_b()).getCurrentAmount(this.output.getStackInSlot(0)) < ((AmountItem)this.output.getStackInSlot(0).func_77973_b()).getMaxCombineAmount()) && this.water.getFluidAmount() >= 1000;
    }

    private int getSlotsFilled() {
        int amount = 0;
        for (int i = 0; i < this.input.getSlots(); ++i) {
            if (this.input.getStackInSlot(i).func_190926_b()) continue;
            ++amount;
        }
        return amount;
    }

    public ProgressBarComponent<RiceCookerTile> getBar() {
        return this.bar;
    }
}

