/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.tile.machinery;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IFoodType;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.api.impl.FoodHelper;
import com.buuz135.sushigocrafting.cap.SushiWeightDiscoveryCapability;
import com.buuz135.sushigocrafting.client.gui.RollerWeightSelectorButtonComponent;
import com.buuz135.sushigocrafting.client.gui.provider.RollerAssetProvider;
import com.buuz135.sushigocrafting.component.FoodTypeButtonComponent;
import com.buuz135.sushigocrafting.component.RollerCraftButtonComponent;
import com.buuz135.sushigocrafting.item.FoodItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;

public class RollerTile
extends ActiveTile<RollerTile> {
    @Save
    private InventoryComponent<RollerTile> slots;
    @Save
    private String selected;
    @Save
    private WeightTracker weightTracker;
    @Save
    private int craftProgress;
    @Save
    private InventoryComponent<RollerTile> spices;

    public RollerTile() {
        super((BasicTileBlock)SushiContent.Blocks.ROLLER.get());
        int i = 0;
        int max = 0;
        this.craftProgress = 0;
        for (IFoodType foodType : FoodAPI.get().getFoodTypes()) {
            this.addButton(new FoodTypeButtonComponent(foodType, -20, i * 20 + 10, 18, 18){

                @Override
                public Supplier<String> getSelected() {
                    return () -> RollerTile.this.selected;
                }
            }.setComponent(this::getSlots));
            if (this.selected == null) {
                this.selected = foodType.getName();
            }
            max = Math.max(max, foodType.getFoodIngredients().size());
            ++i;
        }
        this.weightTracker = new WeightTracker(max);
        this.slots = new InventoryComponent("slots", 0, 0, max).setSlotPosition(FoodAPI.get().getTypeFromName(this.selected).get().getSlotPosition()).setInputFilter((stack, integer) -> {
            List<IFoodIngredient[]> ingredients = FoodAPI.get().getTypeFromName(this.selected).get().getFoodIngredients();
            if (integer >= ingredients.size()) {
                return false;
            }
            for (IFoodIngredient ingredient : ingredients.get((int)integer)) {
                if (ingredient.isEmpty() || !ingredient.getItem().equals(stack.func_77973_b())) continue;
                return true;
            }
            return false;
        });
        FoodAPI.get().getTypeFromName(this.selected).ifPresent(iFoodType -> {
            int i1 = 0;
            while (i1 < this.slots.getSlots()) {
                final int finalI = i1++;
                this.addGuiAddonFactory(() -> new RollerWeightSelectorButtonComponent(this.slots, finalI){

                    @Override
                    public int getWeight() {
                        return (Integer)RollerTile.this.weightTracker.weights.get(finalI);
                    }

                    @Override
                    public String getType() {
                        return RollerTile.this.selected;
                    }
                });
            }
        });
        this.addInventory(this.slots);
        this.spices = new InventoryComponent("spices", 130, 76, 2).setSlotLimit(1).setSlotToColorRender(0, DyeColor.YELLOW).setSlotToColorRender(1, DyeColor.YELLOW).setSlotToItemStackRender(0, new ItemStack((IItemProvider)SushiContent.Items.SOY_SAUCE.get())).setSlotToItemStackRender(1, new ItemStack((IItemProvider)SushiContent.Items.WASABI_PASTE.get())).setInputFilter((stack, integer) -> {
            if (integer == 0) {
                return stack.func_77973_b().equals(SushiContent.Items.SOY_SAUCE.get());
            }
            if (integer == 1) {
                return stack.func_77973_b().equals(SushiContent.Items.WASABI_PASTE.get());
            }
            return false;
        });
        this.addInventory(this.spices);
        this.addButton(new RollerCraftButtonComponent(148, 20, 18, 18).setId(101));
        FoodAPI.get().getTypeFromName(this.selected).ifPresent(iFoodType -> {
            for (int slot = 0; slot < this.slots.getSlots(); ++slot) {
                this.slots.setSlotToItemStackRender(slot, iFoodType.getSlotStackRender().apply(slot));
                this.slots.setSlotToColorRender(slot, 16762729);
            }
        });
    }

    public ActionResultType onActivated(PlayerEntity player, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        ActionResultType type = super.onActivated(player, hand, facing, hitX, hitY, hitZ);
        if (!type.func_226247_b_()) {
            if (player instanceof ServerPlayerEntity) {
                player.getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(iSushiWeightDiscovery -> iSushiWeightDiscovery.requestUpdate((ServerPlayerEntity)player, ItemStack.field_190927_a));
            }
            this.openGui(player);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public void onClick(PlayerEntity player) {
        if (this.isServer()) {
            FoodAPI.get().getTypeFromName(this.selected).ifPresent(iFoodType -> {
                boolean allFull = true;
                for (int i1 = 0; i1 < this.slots.getSlots(); ++i1) {
                    IFoodIngredient ingredient;
                    if (i1 >= iFoodType.getFoodIngredients().size() || (ingredient = FoodAPI.get().getIngredientFromItem(this.slots.getStackInSlot(i1).func_77973_b())).isEmpty() || ingredient.getIngredientConsumer().canConsume(ingredient, this.slots.getStackInSlot(i1), (Integer)this.weightTracker.weights.get(i1))) continue;
                    allFull = false;
                    break;
                }
                if (allFull) {
                    ++this.craftProgress;
                    if (this.craftProgress >= 4) {
                        Random random = new Random(((ServerWorld)this.field_145850_b).func_72905_C() + (long)this.selected.hashCode());
                        this.craftProgress = 0;
                        ArrayList<IFoodIngredient> foodIngredients = new ArrayList<IFoodIngredient>();
                        ArrayList<Integer> weightValues = new ArrayList<Integer>();
                        AtomicReference<ItemStack> discovery = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
                        for (int slot = 0; slot < this.slots.getSlots(); ++slot) {
                            if (slot >= iFoodType.getFoodIngredients().size()) continue;
                            IFoodIngredient ingredient = FoodAPI.get().getIngredientFromItem(this.slots.getStackInSlot(slot).func_77973_b());
                            foodIngredients.add(ingredient);
                        }
                        FoodItem item = FoodHelper.getFoodFromIngredients(this.selected, foodIngredients);
                        if (item != null) {
                            ItemStack stack = new ItemStack((IItemProvider)item);
                            for (int slot = 0; slot < this.slots.getSlots(); ++slot) {
                                if (slot >= iFoodType.getFoodIngredients().size()) continue;
                                IFoodIngredient ingredient = (IFoodIngredient)foodIngredients.get(slot);
                                ingredient.getIngredientConsumer().consume(ingredient, this.slots.getStackInSlot(slot), (Integer)this.weightTracker.weights.get(slot));
                                int value = random.nextInt(5) - (Integer)this.weightTracker.weights.get(slot);
                                weightValues.add(value);
                                if (value != 0 || ingredient.isEmpty()) continue;
                                int finalSlot = slot;
                                player.getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(iSushiWeightDiscovery -> {
                                    if (!iSushiWeightDiscovery.hasDiscovery(this.selected + "-" + finalSlot)) {
                                        iSushiWeightDiscovery.setDiscovery(this.selected + "-" + finalSlot, (Integer)this.weightTracker.weights.get(finalSlot));
                                        discovery.set(stack.func_77946_l());
                                    }
                                });
                            }
                            stack.func_196082_o().func_197646_b("Weights", weightValues);
                            CompoundNBT spicesNBT = new CompoundNBT();
                            for (int i = 0; i < this.spices.getSlots(); ++i) {
                                IFoodIngredient soy;
                                if (this.spices.getStackInSlot(i).func_190926_b() || !(soy = FoodAPI.get().getIngredientFromItem(this.spices.getStackInSlot(i).func_77973_b())).getIngredientConsumer().canConsume(soy, this.spices.getStackInSlot(i), 0)) continue;
                                soy.getIngredientConsumer().consume(soy, this.spices.getStackInSlot(i), 0);
                                spicesNBT.func_74757_a(soy.getName(), true);
                            }
                            stack.func_196082_o().func_218657_a("Spices", (INBT)spicesNBT);
                            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (ItemStack)stack);
                        }
                        if (player instanceof ServerPlayerEntity) {
                            player.getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(iSushiWeightDiscovery -> iSushiWeightDiscovery.requestUpdate((ServerPlayerEntity)player, (ItemStack)discovery.get()));
                        }
                    }
                }
            });
        }
    }

    public void handleButtonMessage(int id, PlayerEntity playerEntity, CompoundNBT compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        if (compound.func_74764_b("Type")) {
            FoodAPI.get().getTypeFromName(compound.func_74779_i("Type")).ifPresent(iFoodType -> {
                int i;
                ItemStack slotStack;
                this.slots.setSlotPosition(iFoodType.getSlotPosition());
                for (int i1 = 0; i1 < this.slots.getSlots(); ++i1) {
                    if (i1 < iFoodType.getFoodIngredients().size()) {
                        this.slots.setSlotLimit(i1, 64);
                        continue;
                    }
                    slotStack = this.slots.getStackInSlot(i1).func_77946_l();
                    this.slots.setStackInSlot(i1, ItemStack.field_190927_a);
                    this.slots.setSlotLimit(i1, 0);
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerEntity, (ItemStack)slotStack);
                }
                this.selected = compound.func_74779_i("Type");
                for (i = 0; i < this.slots.getSlots(); ++i) {
                    this.slots.setSlotToItemStackRender(i, iFoodType.getSlotStackRender().apply(i));
                }
                this.syncObject(this.slots);
                for (i = 0; i < this.slots.getSlots(); ++i) {
                    if (this.slots.isItemValid(i, this.slots.getStackInSlot(i))) continue;
                    slotStack = this.slots.getStackInSlot(i).func_77946_l();
                    this.slots.setStackInSlot(i, ItemStack.field_190927_a);
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerEntity, (ItemStack)slotStack);
                }
                this.markForUpdate();
            });
        }
        if (id == 100) {
            int weight = compound.func_74762_e("WeightSlot");
            int button = compound.func_74762_e("Button");
            if (button == 0) {
                this.weightTracker.weights.set(weight, Math.min(4, (Integer)this.weightTracker.weights.get(weight) + 1));
            }
            if (button == 1) {
                this.weightTracker.weights.set(weight, Math.max(0, (Integer)this.weightTracker.weights.get(weight) - 1));
            }
            this.syncObject(this.weightTracker);
        }
        if (id == 101) {
            int amount = 1;
            if (compound.func_74764_b("Button")) {
                amount = compound.func_74762_e("Button") == 1 ? 64 : 1;
            }
            for (int i = 0; i < amount; ++i) {
                this.craftProgress = 4;
                this.onClick(playerEntity);
            }
        }
    }

    public RollerTile getSelf() {
        return this;
    }

    public void func_73660_a() {
        super.func_73660_a();
    }

    public InventoryComponent<RollerTile> getSlots() {
        return this.slots;
    }

    public IAssetProvider getAssetProvider() {
        return RollerAssetProvider.INSTANCE;
    }

    private class WeightTracker
    implements INBTSerializable<CompoundNBT> {
        private List<Integer> weights = new ArrayList<Integer>();

        public WeightTracker(int amount) {
            for (int i = 0; i < amount; ++i) {
                this.weights.add(0);
            }
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_197646_b("Weights", this.weights);
            return compoundNBT;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.weights = new ArrayList<Integer>();
            for (int i : nbt.func_74759_k("Weights")) {
                this.weights.add(i);
            }
        }
    }
}

