/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting;

import com.buuz135.sushigocrafting.api.IFoodType;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.api.impl.FoodHelper;
import com.buuz135.sushigocrafting.cap.ISushiWeightDiscovery;
import com.buuz135.sushigocrafting.cap.SushiDiscoveryProvider;
import com.buuz135.sushigocrafting.cap.SushiWeightDiscoveryCapability;
import com.buuz135.sushigocrafting.client.ClientProxy;
import com.buuz135.sushigocrafting.client.render.ContributorsBackRender;
import com.buuz135.sushigocrafting.datagen.SushiBlockTagsProvider;
import com.buuz135.sushigocrafting.datagen.SushiBlockstateProvider;
import com.buuz135.sushigocrafting.datagen.SushiItemModelProvider;
import com.buuz135.sushigocrafting.datagen.SushiItemTagsProvider;
import com.buuz135.sushigocrafting.datagen.SushiLangProvider;
import com.buuz135.sushigocrafting.datagen.SushiLootTableProvider;
import com.buuz135.sushigocrafting.datagen.SushiModelProvider;
import com.buuz135.sushigocrafting.datagen.SushiRecipeProvider;
import com.buuz135.sushigocrafting.datagen.SushiSerializableProvider;
import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.network.CapabilitySyncMessage;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.buuz135.sushigocrafting.recipe.CombineAmountItemRecipe;
import com.buuz135.sushigocrafting.recipe.CuttingBoardRecipe;
import com.buuz135.sushigocrafting.recipe.FermentingBarrelRecipe;
import com.buuz135.sushigocrafting.tile.machinery.CoolerBoxTile;
import com.buuz135.sushigocrafting.tile.machinery.CuttingBoardTile;
import com.buuz135.sushigocrafting.tile.machinery.FermentationBarrelTile;
import com.buuz135.sushigocrafting.tile.machinery.RiceCookerTile;
import com.buuz135.sushigocrafting.tile.machinery.RollerTile;
import com.buuz135.sushigocrafting.world.SushiTab;
import com.buuz135.sushigocrafting.world.tree.AvocadoTree;
import com.hrznstudio.titanium.TitaniumClient;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardGiver;
import com.hrznstudio.titanium.reward.RewardManager;
import java.net.URL;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidWithNoiseConfig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.PistonEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sushigocrafting")
public class SushiGoCrafting
extends ModuleController {
    public static final String MOD_ID = "sushigocrafting";
    public static final ItemGroup TAB = new SushiTab("sushigocrafting");
    public static NetworkHandler NETWORK = new NetworkHandler("sushigocrafting");
    public static Logger LOGGER = LogManager.getLogger((String)"sushigocrafting");

    public SushiGoCrafting() {
        FoodAPI.get();
        FoodAPI.get().init();
        SushiContent.Blocks.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        SushiContent.Items.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        SushiContent.Features.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        SushiContent.TileEntities.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        SushiContent.Effects.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        SushiContent.EntityTypes.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        SushiContent.LootSerializers.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> EventManager.mod(FMLClientSetupEvent.class).process(fmlClientSetupEvent -> new ClientProxy().fmlClient((FMLClientSetupEvent)fmlClientSetupEvent)).subscribe());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> EventManager.mod(ModelRegistryEvent.class).process(modelRegistryEvent -> {
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation(MOD_ID, "block/salmon_back"));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation(MOD_ID, "block/tuna_back"));
        }).subscribe());
        EventManager.mod(FMLCommonSetupEvent.class).process(this::fmlCommon).subscribe();
        EventManager.mod(GatherDataEvent.class).process(this::dataGen).subscribe();
        EventManager.modGeneric(RegistryEvent.Register.class, IRecipeSerializer.class).process(register -> ((RegistryEvent.Register)register).getRegistry().registerAll(new IForgeRegistryEntry[]{(IForgeRegistryEntry)CombineAmountItemRecipe.SERIALIZER.setRegistryName(new ResourceLocation(MOD_ID, "amount_combine_recipe")), CuttingBoardRecipe.SERIALIZER, FermentingBarrelRecipe.SERIALIZER})).subscribe();
        for (IFoodType value : FoodAPI.get().getFoodTypes()) {
            FoodHelper.generateFood(value).forEach(item -> SushiContent.Items.REGISTRY.register(FoodHelper.getName(item), () -> item));
        }
        NBTManager.getInstance().scanTileClassForAnnotations(RollerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(RiceCookerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(CuttingBoardTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(CoolerBoxTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(FermentationBarrelTile.class);
        EventManager.forge(BiomeLoadingEvent.class).filter(biomeLoadingEvent -> biomeLoadingEvent.getCategory() == Biome.Category.OCEAN).process(biomeLoadingEvent -> {
            biomeLoadingEvent.getSpawns().func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)SushiContent.EntityTypes.TUNA.get(), 8, 3, 6));
            biomeLoadingEvent.getSpawns().func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)SushiContent.EntityTypes.SHRIMP.get(), 10, 6, 9));
            biomeLoadingEvent.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> ((Feature)SushiContent.Features.SEAWEED.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((ConfiguredPlacement)Features.Placements.field_243995_f.func_242728_a()).func_227228_a_(Placement.field_242901_e.func_227446_a_((IPlacementConfig)new TopSolidWithNoiseConfig(80, 80.0, 0.0)))));
        }).subscribe();
        EventManager.modGeneric(RegistryEvent.Register.class, EntityType.class).process(register -> {
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)SushiContent.EntityTypes.SHRIMP.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AbstractFishEntity::func_223363_b);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)SushiContent.EntityTypes.TUNA.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AbstractFishEntity::func_223363_b);
        }).subscribe();
        EventManager.forge(BiomeLoadingEvent.class).filter(biomeLoadingEvent -> biomeLoadingEvent.getCategory() == Biome.Category.PLAINS).process(biomeLoadingEvent -> biomeLoadingEvent.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> Feature.field_236291_c_.func_225566_b_((IFeatureConfig)AvocadoTree.TREE).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242898_b.func_227446_a_((IPlacementConfig)new ChanceConfig(6))))).subscribe();
        EventManager.forge(PistonEvent.Pre.class).process(pre -> {
            if (pre.getWorld().func_180495_p(pre.getFaceOffsetPos()).func_177230_c().equals(SushiContent.Blocks.SEAWEED_BLOCK.get()) && pre.getWorld().func_180495_p(pre.getPos().func_177967_a(pre.getDirection(), 2)).func_177230_c().equals(Blocks.field_150339_S)) {
                pre.getWorld().func_175655_b(pre.getFaceOffsetPos(), false);
                NonNullList list = NonNullList.func_191196_a();
                list.add((Object)new ItemStack((IItemProvider)SushiContent.Items.NORI_SHEET.get(), 5 + pre.getWorld().func_201674_k().nextInt(4)));
                InventoryHelper.func_219961_a((World)((World)pre.getWorld()), (BlockPos)pre.getFaceOffsetPos().func_177963_a(0.5, 0.5, 0.5), (NonNullList)list);
            }
        }).subscribe();
        EventManager.mod(EntityAttributeCreationEvent.class).process(entityAttributeCreationEvent -> {
            entityAttributeCreationEvent.put((EntityType)SushiContent.EntityTypes.TUNA.get(), AbstractFishEntity.func_234176_m_().func_233813_a_());
            entityAttributeCreationEvent.put((EntityType)SushiContent.EntityTypes.SHRIMP.get(), AbstractFishEntity.func_234176_m_().func_233813_a_());
        }).subscribe();
        EventManager.forge(LivingDropsEvent.class).filter(livingDropsEvent -> livingDropsEvent.getEntity() instanceof AbstractFishEntity).process(livingDropsEvent -> {
            if (livingDropsEvent.getEntity().field_70170_p.func_201674_k().nextInt(10) <= 2) {
                livingDropsEvent.getDrops().add(new ItemEntity(livingDropsEvent.getEntity().field_70170_p, livingDropsEvent.getEntity().func_226277_ct_(), livingDropsEvent.getEntity().func_226278_cu_(), livingDropsEvent.getEntity().func_226281_cx_(), ((AmountItem)SushiContent.Items.TOBIKO.get()).random(null, livingDropsEvent.getEntity().field_70170_p)));
            }
        }).subscribe();
        RewardGiver giver = RewardManager.get().getGiver(UUID.fromString("d28b7061-fb92-4064-90fb-7e02b95a72a6"), "Buuz135");
        try {
            giver.addReward(new Reward(new ResourceLocation(MOD_ID, "back"), new URL("https://raw.githubusercontent.com/Buuz135/Industrial-Foregoing/master/contributors.json"), () -> dist -> {
                if (dist == Dist.CLIENT) {
                    this.registerReward();
                }
            }, new String[]{"salmon", "tuna"}));
        }
        catch (Exception e) {
            LOGGER.catching((Throwable)e);
        }
    }

    protected void initModules() {
    }

    public void fmlCommon(FMLCommonSetupEvent event) {
        this.registerCapability();
    }

    public void dataGen(GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new SushiModelProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().func_200390_a((IDataProvider)new SushiBlockstateProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().func_200390_a((IDataProvider)new SushiItemModelProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().func_200390_a((IDataProvider)new SushiLangProvider(event.getGenerator(), MOD_ID, "en_us"));
        SushiBlockTagsProvider provider = new SushiBlockTagsProvider(event.getGenerator(), event.getExistingFileHelper());
        event.getGenerator().func_200390_a((IDataProvider)provider);
        event.getGenerator().func_200390_a((IDataProvider)new SushiItemTagsProvider(event.getGenerator(), (BlockTagsProvider)provider, event.getExistingFileHelper()));
        event.getGenerator().func_200390_a((IDataProvider)new SushiSerializableProvider(event.getGenerator(), MOD_ID));
        event.getGenerator().func_200390_a((IDataProvider)new SushiLootTableProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new SushiRecipeProvider(event.getGenerator()));
    }

    private void registerCapability() {
        CapabilityManager.INSTANCE.register(ISushiWeightDiscovery.class, (Capability.IStorage)new SushiWeightDiscoveryCapability.Storage(), SushiWeightDiscoveryCapability::new);
        EventManager.forgeGeneric(AttachCapabilitiesEvent.class, Entity.class).filter(attachCapabilitiesEvent -> ((AttachCapabilitiesEvent)attachCapabilitiesEvent).getObject() instanceof PlayerEntity).process(attachCapabilitiesEvent -> ((AttachCapabilitiesEvent)attachCapabilitiesEvent).addCapability(new ResourceLocation(MOD_ID, "weight_discovery"), (ICapabilityProvider)new SushiDiscoveryProvider())).subscribe();
        EventManager.forge(PlayerEvent.Clone.class).process(clone -> clone.getOriginal().getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(original -> clone.getPlayer().getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(future -> {
            future.deserializeNBT(original.serializeNBT());
            future.requestUpdate((ServerPlayerEntity)clone.getPlayer(), ItemStack.field_190927_a);
        }))).subscribe();
        EventManager.forge(PlayerEvent.PlayerLoggedInEvent.class).filter(playerLoggedInEvent -> playerLoggedInEvent.getPlayer() instanceof ServerPlayerEntity).process(playerLoggedInEvent -> playerLoggedInEvent.getPlayer().getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(iSushiWeightDiscovery -> iSushiWeightDiscovery.requestUpdate((ServerPlayerEntity)playerLoggedInEvent.getPlayer(), ItemStack.field_190927_a))).subscribe();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerReward() {
        Minecraft instance = Minecraft.func_71410_x();
        EntityRendererManager manager = instance.func_175598_ae();
        ((PlayerRenderer)manager.getSkinMap().get("default")).func_177094_a((LayerRenderer)new ContributorsBackRender((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)TitaniumClient.getPlayerRenderer((Minecraft)Minecraft.func_71410_x())));
        ((PlayerRenderer)manager.getSkinMap().get("slim")).func_177094_a((LayerRenderer)new ContributorsBackRender((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)TitaniumClient.getPlayerRenderer((Minecraft)Minecraft.func_71410_x())));
    }

    static {
        ForgeMod.enableMilkFluid();
        NETWORK.registerMessage(CapabilitySyncMessage.class);
    }
}

