/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.compat.jei.categories;

import com.buuz135.sushigocrafting.block.machinery.RollerBlock;
import com.buuz135.sushigocrafting.client.gui.RollerWeightSelectorButtonComponent;
import com.buuz135.sushigocrafting.client.gui.provider.RollerAssetProvider;
import com.buuz135.sushigocrafting.item.FoodItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.hrznstudio.titanium.client.screen.addon.SlotsScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class RollerCategory
implements IRecipeCategory<Recipe> {
    public static ResourceLocation UID = new ResourceLocation("sushigocrafting", "roller");
    private final IGuiHelper guiHelper;

    public RollerCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public String getTitle() {
        return new TranslationTextComponent(((RollerBlock)SushiContent.Blocks.ROLLER.get()).func_149739_a()).getString();
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(new ResourceLocation("sushigocrafting", "textures/gui/roller.png"), 8, 17, 160, 79);
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(Recipe recipe, IIngredients iIngredients) {
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)recipe.stack));
        iIngredients.setInputs(VanillaTypes.ITEM, recipe.stack.getIngredientList().stream().filter(iFoodIngredient -> !iFoodIngredient.isEmpty()).map(iFoodIngredient -> new ItemStack((IItemProvider)iFoodIngredient.getItem())).collect(Collectors.toList()));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup stackGroup = iRecipeLayout.getItemStacks();
        stackGroup.init(0, false, 4, 2);
        stackGroup.set(0, new ItemStack((IItemProvider)recipe.stack));
        for (int i = 0; i < recipe.stack.getIngredientList().size(); ++i) {
            if (recipe.stack.getIngredientList().get(i).isEmpty()) continue;
            stackGroup.init(i + 1, true, (Integer)recipe.stack.getType().getSlotPosition().apply(i).getLeft() - 8, (Integer)recipe.stack.getType().getSlotPosition().apply(i).getRight() - 18);
            stackGroup.set(i + 1, new ItemStack((IItemProvider)recipe.stack.getIngredientList().get(i).getItem()));
        }
    }

    public void draw(Recipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        SlotsScreenAddon.drawAsset((MatrixStack)matrixStack, (Screen)Minecraft.func_71410_x().field_71462_r, (IAssetProvider)RollerAssetProvider.INSTANCE, (int)5, (int)3, (int)0, (int)0, (int)1, integer -> Pair.of((Object)0, (Object)0), integer -> ItemStack.field_190927_a, (boolean)true, integer -> new Color(DyeColor.ORANGE.func_196060_f()), integer -> true);
        SlotsScreenAddon.drawAsset((MatrixStack)matrixStack, (Screen)Minecraft.func_71410_x().field_71462_r, (IAssetProvider)RollerAssetProvider.INSTANCE, (int)-7, (int)-17, (int)0, (int)0, (int)recipe.stack.getIngredientList().size(), recipe.stack.getType().getSlotPosition(), integer -> ItemStack.field_190927_a, (boolean)true, integer -> new Color(DyeColor.LIGHT_BLUE.func_196060_f()), integer -> true);
        for (int i = 0; i < recipe.stack.getIngredientList().size(); ++i) {
            RollerWeightSelectorButtonComponent.drawBackground(matrixStack, Minecraft.func_71410_x().field_71462_r, RollerAssetProvider.INSTANCE, 0, 0, (Integer)recipe.stack.getType().getSlotPosition().apply(i).getLeft() - 8 + 18, (Integer)recipe.stack.getType().getSlotPosition().apply(i).getRight() - 18);
            RollerWeightSelectorButtonComponent.drawForeground(matrixStack, Minecraft.func_71410_x().field_71462_r, RollerAssetProvider.INSTANCE, 0, 0, (Integer)recipe.stack.getType().getSlotPosition().apply(i).getLeft() - 8 + 18, (Integer)recipe.stack.getType().getSlotPosition().apply(i).getRight() - 18, Integer.MIN_VALUE, 18, recipe.stack.getType().getName(), i);
        }
    }

    public static class Recipe {
        private final FoodItem stack;

        public Recipe(FoodItem stack) {
            this.stack = stack;
        }
    }
}

