/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.datagen;

import com.buuz135.sushigocrafting.block.plant.CustomCropBlock;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class SushiLootTableProvider
extends LootTableProvider {
    public SushiLootTableProvider(DataGenerator gen) {
        super(gen);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return Arrays.asList(Pair.of(() -> new SushiBlockLootTables(), (Object)LootParameterSets.field_216267_h), Pair.of(() -> new SushiEntityLootTables(), (Object)LootParameterSets.field_216263_d));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
    }

    private class SushiEntityLootTables
    extends EntityLootTables {
        private SushiEntityLootTables() {
        }

        protected void addTables() {
            this.func_218582_a((EntityType)SushiContent.EntityTypes.TUNA.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)SushiContent.Items.RAW_TUNA.get())))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_196106_bc)).func_212840_b_(RandomChance.func_216004_a((float)0.05f))));
            this.func_218582_a((EntityType)SushiContent.EntityTypes.SHRIMP.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)SushiContent.Items.SHRIMP.get())))));
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return Arrays.asList((EntityType)SushiContent.EntityTypes.TUNA.get(), (EntityType)SushiContent.EntityTypes.SHRIMP.get());
        }
    }

    private static class SushiBlockLootTables
    extends BlockLootTables {
        private List<Block> knownBlocks = new ArrayList<Block>();

        private SushiBlockLootTables() {
        }

        protected void addTables() {
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.RICE_CROP, (Supplier<? extends Item>)SushiContent.Items.RICE);
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.CUCUMBER_CROP, (Supplier<? extends Item>)SushiContent.Items.CUCUMBER);
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.SOY_CROP, (Supplier<? extends Item>)SushiContent.Items.SOY_BEAN);
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.WASABI_CROP, (Supplier<? extends Item>)SushiContent.Items.WASABI_ROOT);
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.SESAME_CROP, (Supplier<? extends Item>)SushiContent.Items.SESAME_SEED);
            this.dropOther((Supplier<Block>)SushiContent.Blocks.SEAWEED, (Supplier<? extends IItemProvider>)SushiContent.Items.SEAWEED);
            this.dropOther((Supplier<Block>)SushiContent.Blocks.SEAWEED_PLANT, (Supplier<? extends IItemProvider>)SushiContent.Items.SEAWEED);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.AVOCADO_SAPLING);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.RICE_COOKER);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.SEAWEED_BLOCK);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.CUTTING_BOARD);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.AVOCADO_LOG);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.ROLLER);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.FERMENTATION_BARREL);
            this.dropLeaves((Supplier<Block>)SushiContent.Blocks.AVOCADO_LEAVES, (Supplier<Block>)SushiContent.Blocks.AVOCADO_SAPLING);
            this.dropLeavesSpecial((Supplier<? extends Block>)SushiContent.Blocks.AVOCADO_LEAVES_LOG, (Supplier<? extends Block>)SushiContent.Blocks.AVOCADO_LOG);
            CopyNbt.Builder nbtBuilder = CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY);
            nbtBuilder.func_216056_a("input", "BlockEntityTag.input");
            this.droppingSelfWithNbt((Supplier<? extends Block>)SushiContent.Blocks.COOLER_BOX, nbtBuilder);
        }

        private void crop(Supplier<CustomCropBlock> blockSupplier, Supplier<? extends Item> extra) {
            BlockStateProperty.Builder condition = BlockStateProperty.func_215985_a((Block)((Block)blockSupplier.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)blockSupplier.get().func_185524_e(), blockSupplier.get().func_185526_g()));
            this.func_218507_a((Block)blockSupplier.get(), SushiBlockLootTables.func_218541_a((Block)((Block)blockSupplier.get()), (Item)extra.get(), (Item)blockSupplier.get().func_199772_f().func_199767_j(), (ILootCondition.IBuilder)condition));
            this.knownBlocks.add((Block)blockSupplier.get());
        }

        private void dropSelf(Supplier<? extends Block> blockSupplier) {
            this.func_218492_c(blockSupplier.get());
            this.knownBlocks.add(blockSupplier.get());
        }

        private void dropOther(Supplier<Block> blockSupplier, Supplier<? extends IItemProvider> other) {
            this.func_218493_a(blockSupplier.get(), other.get());
            this.knownBlocks.add(blockSupplier.get());
        }

        private void dropLeaves(Supplier<Block> blockSupplier, Supplier<Block> sapling) {
            this.func_218522_a(blockSupplier.get(), leaves -> SushiBlockLootTables.func_218540_a((Block)leaves, (Block)((Block)sapling.get()), (float[])new float[]{0.15f, 0.2f, 0.3f, 0.4f}));
            this.knownBlocks.add(blockSupplier.get());
        }

        private void dropLeavesSpecial(Supplier<? extends Block> blockSupplier, Supplier<? extends Block> extra) {
            this.func_218522_a(blockSupplier.get(), block -> SushiBlockLootTables.func_218535_c((Block)block, (LootEntry.Builder)((LootEntry.Builder)SushiBlockLootTables.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)extra.get()))))));
            this.knownBlocks.add(blockSupplier.get());
        }

        public void droppingSelfWithNbt(Supplier<? extends Block> itemProvider, CopyNbt.Builder nbtBuilder) {
            this.func_218507_a(itemProvider.get(), LootTable.func_216119_b().func_216040_a((LootPool.Builder)SushiBlockLootTables.func_218560_a((IItemProvider)((IItemProvider)itemProvider.get()), (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)itemProvider.get())).func_212841_b_((ILootFunction.IBuilder)nbtBuilder)))));
            this.knownBlocks.add(itemProvider.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }
    }
}

