/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.item;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IFoodType;
import com.buuz135.sushigocrafting.api.IIngredientEffect;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.api.impl.effect.ModifyIngredientEffect;
import com.buuz135.sushigocrafting.item.SushiItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class FoodItem
extends SushiItem {
    public static final String WEIGHTS_TAG = "Weights";
    public static final String SPICES_TAG = "Spices";
    private final List<IFoodIngredient> ingredientList;
    private final IFoodType type;

    public FoodItem(Item.Properties properties, IFoodType type) {
        super(properties.func_221540_a(new Food.Builder().func_221453_d()), type.getName());
        this.type = type;
        this.ingredientList = new ArrayList<IFoodIngredient>();
    }

    public List<IFoodIngredient> getIngredientList() {
        return this.ingredientList;
    }

    public IFoodType getType() {
        return this.type;
    }

    public static String getWeightText(int weight) {
        if (weight < 0) {
            return (weight == -1 ? TextFormatting.RED : TextFormatting.DARK_RED) + "\u25be";
        }
        if (weight > 0) {
            return (weight == 1 ? TextFormatting.RED : TextFormatting.DARK_RED) + "\u25b4";
        }
        return TextFormatting.GOLD + "\uff65";
    }

    public static List<ITextComponent> getTagsFrom(int negative, int positive) {
        ArrayList<ITextComponent> names = new ArrayList<ITextComponent>();
        if (negative == 0 && positive == 0) {
            names.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Perfect"));
        } else if (Math.abs(negative) == positive) {
            names.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_GREEN + "Weirdly Balanced"));
        }
        if (Math.abs(negative) < positive) {
            names.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Almost Hollow"));
        }
        if (Math.abs(negative) > positive) {
            names.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Overflowing"));
        }
        return names;
    }

    public static ModifyIngredientEffect getModifierFrom(int negative, int positive) {
        if (negative == 0 && positive == 0) {
            return new ModifyIngredientEffect(2.0f, 1);
        }
        if (Math.abs(negative) == positive) {
            return new ModifyIngredientEffect(1.2f, 0);
        }
        if (Math.abs(negative) < positive) {
            return new ModifyIngredientEffect(0.8f, 0);
        }
        if (Math.abs(negative) > positive) {
            return new ModifyIngredientEffect(0.8f, 0);
        }
        return new ModifyIngredientEffect(1.0f, 0);
    }

    public static float getFoodModifierValue(int negative, int positive) {
        if (negative == 0 && positive == 0) {
            return 1.25f;
        }
        if (Math.abs(negative) == positive) {
            return 0.9f;
        }
        return 0.8f;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Ingredients: "));
        for (int i = 0; i < this.ingredientList.size(); ++i) {
            if (this.ingredientList.get(i).isEmpty()) continue;
            Object line = TextFormatting.GRAY + " - " + new TranslationTextComponent(this.ingredientList.get(i).getItem().func_77658_a()).getString();
            if (stack.func_77942_o()) {
                line = (String)line + " " + FoodItem.getWeightText(stack.func_77978_p().func_74759_k(WEIGHTS_TAG)[i]);
            }
            tooltip.add((ITextComponent)new StringTextComponent((String)line));
        }
        if (stack.func_77942_o() && stack.func_179543_a(SPICES_TAG) != null) {
            CompoundNBT compoundNBT = stack.func_179543_a(SPICES_TAG);
            for (String name : compoundNBT.func_150296_c()) {
                IFoodIngredient foodIngredient = FoodAPI.get().getIngredientFromName(name);
                if (foodIngredient.isEmpty()) continue;
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + " - " + new TranslationTextComponent(foodIngredient.getItem().func_77658_a()).getString()));
            }
        }
        boolean hasShift = Screen.func_231173_s_();
        boolean hasAlt = Screen.func_231174_t_();
        Info info = new Info(stack, hasShift);
        tooltip.addAll(FoodItem.getTagsFrom(info.getNegative(), info.getPositive()));
        tooltip.add((ITextComponent)new StringTextComponent(""));
        if (hasShift) {
            if (info.getEffectInstances().size() > 0) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + "Effects:"));
                if (hasAlt) {
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + " - " + TextFormatting.GOLD + "Hunger: " + TextFormatting.WHITE + (int)info.getHunger()));
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + " - " + TextFormatting.GOLD + "Saturation: " + TextFormatting.WHITE + info.getSaturation()));
                }
                info.getEffectInstances().forEach(effectInstance -> tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + " - " + TextFormatting.GOLD + effectInstance.func_188419_a().func_199286_c().getString() + TextFormatting.DARK_AQUA + " (" + TextFormatting.WHITE + effectInstance.func_76459_b() / 20 + TextFormatting.YELLOW + "s" + TextFormatting.DARK_AQUA + ", " + TextFormatting.YELLOW + "Level " + TextFormatting.WHITE + (effectInstance.func_76458_c() + 1) + TextFormatting.DARK_AQUA + ")")));
            }
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Hold " + TextFormatting.GOLD + "" + TextFormatting.ITALIC + "<Shift>" + TextFormatting.RESET + TextFormatting.YELLOW + " for sushi effect"));
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            Info info = new Info(stack, true);
            player.func_71024_bL().func_75122_a((int)info.getHunger(), info.getSaturation());
            info.getEffectInstances().forEach(arg_0 -> ((PlayerEntity)player).func_195064_c(arg_0));
            worldIn.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.func_213353_d(stack), SoundCategory.NEUTRAL, 1.0f, 1.0f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.4f);
            if (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return stack;
        }
        return entity.func_213357_a(worldIn, stack);
    }

    @Nullable
    public Food func_219967_s() {
        return new Food.Builder().func_221456_a(this.getIngredientList().stream().mapToInt(IFoodIngredient::getHungerValue).sum()).func_221454_a((float)this.getIngredientList().stream().mapToInt(IFoodIngredient::getSaturationValue).sum()).func_221453_d();
    }

    public static class Info {
        private final ItemStack stack;
        private final List<EffectInstance> effectInstances;
        private ModifyIngredientEffect modifyIngredientEffect;
        private int positive;
        private int negative = 0;
        private float saturation;
        private float hunger;

        public Info(ItemStack stack, boolean calculateEffects) {
            this.stack = stack;
            this.effectInstances = new ArrayList<EffectInstance>();
            this.modifyIngredientEffect = null;
            if (stack.func_77942_o()) {
                for (int i : stack.func_77978_p().func_74759_k(FoodItem.WEIGHTS_TAG)) {
                    if (i < 0) {
                        this.negative += i;
                    }
                    if (i <= 0) continue;
                    this.positive += i;
                }
                this.modifyIngredientEffect = FoodItem.getModifierFrom(this.negative, this.positive);
            }
            FoodItem foodItem = (FoodItem)stack.func_77973_b();
            this.hunger = (float)foodItem.getIngredientList().stream().map(IFoodIngredient::getHungerValue).mapToInt(Integer::intValue).sum() * FoodItem.getFoodModifierValue(this.negative, this.positive);
            this.saturation = (float)foodItem.getIngredientList().stream().map(IFoodIngredient::getSaturationValue).mapToInt(Integer::intValue).sum() * FoodItem.getFoodModifierValue(this.negative, this.positive);
            if (calculateEffects) {
                ArrayList<IFoodIngredient> foodIngredients = new ArrayList<IFoodIngredient>(foodItem.getIngredientList());
                if (stack.func_77942_o() && stack.func_179543_a(FoodItem.SPICES_TAG) != null) {
                    CompoundNBT compoundNBT = stack.func_179543_a(FoodItem.SPICES_TAG);
                    for (String name : compoundNBT.func_150296_c()) {
                        IFoodIngredient foodIngredient = FoodAPI.get().getIngredientFromName(name);
                        if (foodIngredient.isEmpty()) continue;
                        foodIngredients.add(foodIngredient);
                    }
                }
                foodIngredients.stream().map(IFoodIngredient::getEffect).filter(Objects::nonNull).sorted(Comparator.comparingInt(IIngredientEffect::getPriority)).forEach(iIngredientEffect -> iIngredientEffect.accept(this.effectInstances));
                if (this.modifyIngredientEffect != null) {
                    this.modifyIngredientEffect.accept(this.effectInstances);
                }
            }
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public List<EffectInstance> getEffectInstances() {
            return this.effectInstances;
        }

        public ModifyIngredientEffect getModifyIngredientEffect() {
            return this.modifyIngredientEffect;
        }

        public int getPositive() {
            return this.positive;
        }

        public int getNegative() {
            return this.negative;
        }

        public float getSaturation() {
            return this.saturation;
        }

        public float getHunger() {
            return this.hunger;
        }
    }
}

