/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.proxy;

import com.buuz135.sushigocrafting.SushiGoCrafting;
import com.buuz135.sushigocrafting.block.SushiGoCraftingBlock;
import com.buuz135.sushigocrafting.block.machinery.CoolerBoxBlock;
import com.buuz135.sushigocrafting.block.machinery.CuttingBoardBlock;
import com.buuz135.sushigocrafting.block.machinery.FermentationBarrelBlock;
import com.buuz135.sushigocrafting.block.machinery.RiceCookerBlock;
import com.buuz135.sushigocrafting.block.machinery.RollerBlock;
import com.buuz135.sushigocrafting.block.plant.AvocadoLeavesBlock;
import com.buuz135.sushigocrafting.block.plant.AvocadoLogBlock;
import com.buuz135.sushigocrafting.block.plant.CustomCropBlock;
import com.buuz135.sushigocrafting.block.plant.WaterCropBlock;
import com.buuz135.sushigocrafting.block.seaweed.SeaWeedBlock;
import com.buuz135.sushigocrafting.block.seaweed.SeaWeedTopBlock;
import com.buuz135.sushigocrafting.entity.ShrimpEntity;
import com.buuz135.sushigocrafting.entity.TunaEntity;
import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.item.SushiItem;
import com.buuz135.sushigocrafting.loot.ItemAmountLootModifier;
import com.buuz135.sushigocrafting.loot.SeedsLootModifier;
import com.buuz135.sushigocrafting.potioneffect.AcquiredTasteEffect;
import com.buuz135.sushigocrafting.potioneffect.SmallBitesEffect;
import com.buuz135.sushigocrafting.potioneffect.SteadyHandsEffect;
import com.buuz135.sushigocrafting.tile.machinery.CoolerBoxTile;
import com.buuz135.sushigocrafting.tile.machinery.CuttingBoardTile;
import com.buuz135.sushigocrafting.tile.machinery.FermentationBarrelTile;
import com.buuz135.sushigocrafting.tile.machinery.RiceCookerTile;
import com.buuz135.sushigocrafting.tile.machinery.RollerTile;
import com.buuz135.sushigocrafting.world.SeaWeedFeature;
import com.buuz135.sushigocrafting.world.tree.AvocadoTree;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.block.trees.Tree;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.entity.passive.fish.CodEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.FishBucketItem;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class SushiContent {
    public static <T extends Block> RegistryObject<T> block(String id, Supplier<T> block) {
        return Blocks.REGISTRY.register(id, block);
    }

    public static RegistryObject<Item> item(String id, Supplier<Item> item) {
        return Items.REGISTRY.register(id, item);
    }

    public static RegistryObject<Item> basicItem(String id, String category) {
        return Items.REGISTRY.register(id, () -> new SushiItem(new Item.Properties().func_200916_a(SushiGoCrafting.TAB), category));
    }

    public static RegistryObject<AmountItem> amountItem(String id, String category, int minAmount, int maxAmount, int maxCombine, boolean hurts) {
        return Items.REGISTRY.register(id, () -> new AmountItem(new Item.Properties().func_200916_a(SushiGoCrafting.TAB).func_200917_a(1), category, minAmount, maxAmount, maxCombine, hurts));
    }

    public static RegistryObject<BlockItem> blockItem(String id, Supplier<? extends Block> sup) {
        return Items.REGISTRY.register(id, () -> new BlockItem((Block)sup.get(), new Item.Properties().func_200916_a(SushiGoCrafting.TAB)));
    }

    public static RegistryObject<BlockItem> blockItem(String id, Supplier<? extends Block> sup, Item.Properties properties) {
        return Items.REGISTRY.register(id, () -> new BlockItem((Block)sup.get(), properties.func_200916_a(SushiGoCrafting.TAB)));
    }

    public static <T extends IFeatureConfig> RegistryObject<Feature<T>> feature(String id, Supplier<Feature<T>> featureSupplier) {
        return Features.REGISTRY.register(id, featureSupplier);
    }

    public static <T extends TileEntity> RegistryObject<TileEntityType<T>> tile(String id, Supplier<T> supplier, Supplier<? extends Block> sup) {
        return TileEntities.REGISTRY.register(id, () -> TileEntityType.Builder.func_223042_a((Supplier)supplier, (Block[])new Block[]{(Block)sup.get()}).func_206865_a(null));
    }

    public static RegistryObject<Effect> effect(String id, Supplier<Effect> supplier) {
        return Effects.REGISTRY.register(id, supplier);
    }

    public static <T extends Entity> RegistryObject<EntityType<T>> entity(String id, Supplier<EntityType<T>> supplier) {
        return EntityTypes.REGISTRY.register(id, supplier);
    }

    public static <T extends IGlobalLootModifier> RegistryObject<GlobalLootModifierSerializer<?>> lootSerializer(String id, Supplier<GlobalLootModifierSerializer<T>> supplier) {
        return LootSerializers.REGISTRY.register(id, supplier);
    }

    public static class LootSerializers {
        public static final DeferredRegister<GlobalLootModifierSerializer<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)"sushigocrafting");
        public static final RegistryObject<GlobalLootModifierSerializer<?>> SEEDS = SushiContent.lootSerializer("grass_seeds", SeedsLootModifier.Serializer::new);
        public static final RegistryObject<GlobalLootModifierSerializer<?>> ITEM_AMOUNT = SushiContent.lootSerializer("item_amount", ItemAmountLootModifier.Serializer::new);
    }

    public static class EntityTypes {
        public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"sushigocrafting");
        public static final RegistryObject<EntityType<TunaEntity>> TUNA = SushiContent.entity("tuna", () -> EntityType.Builder.func_220322_a(TunaEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.7f, 0.4f).func_233606_a_(4).setCustomClientFactory((spawnEntity, world) -> new TunaEntity((EntityType<? extends CodEntity>)((EntityType)EntityTypes.getTuna().get()), (World)world)).func_206830_a("tuna"));
        public static final RegistryObject<EntityType<ShrimpEntity>> SHRIMP = SushiContent.entity("shrimp", () -> EntityType.Builder.func_220322_a(ShrimpEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.7f, 0.4f).func_233606_a_(4).setCustomClientFactory((spawnEntity, world) -> new ShrimpEntity((EntityType<? extends AbstractGroupFishEntity>)((EntityType)EntityTypes.getShrimp().get()), (World)world)).func_206830_a("shrimp"));

        public static RegistryObject<EntityType<TunaEntity>> getTuna() {
            return TUNA;
        }

        public static RegistryObject<EntityType<ShrimpEntity>> getShrimp() {
            return SHRIMP;
        }
    }

    public static class Effects {
        public static final DeferredRegister<Effect> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"sushigocrafting");
        public static final RegistryObject<Effect> ACQUIRED_TASTE = SushiContent.effect("acquired_taste", AcquiredTasteEffect::new);
        public static final RegistryObject<Effect> SMALL_BITES = SushiContent.effect("small_bites", SmallBitesEffect::new);
        public static final RegistryObject<Effect> STEADY_HANDS = SushiContent.effect("steady_hands", SteadyHandsEffect::new);
    }

    public static class Features {
        public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"sushigocrafting");
        public static final RegistryObject<Feature<NoFeatureConfig>> SEAWEED = SushiContent.feature("seaweed", () -> new SeaWeedFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    }

    public static class TileEntities {
        public static final DeferredRegister<TileEntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"sushigocrafting");
        public static RegistryObject<TileEntityType<RollerTile>> ROLLER = SushiContent.tile("roller", RollerTile::new, Blocks.ROLLER);
        public static RegistryObject<TileEntityType<RiceCookerTile>> RICE_COOKER = SushiContent.tile("rice_cooker", RiceCookerTile::new, Blocks.RICE_COOKER);
        public static RegistryObject<TileEntityType<CuttingBoardTile>> CUTTING_BOARD = SushiContent.tile("cutting_board", CuttingBoardTile::new, Blocks.CUTTING_BOARD);
        public static RegistryObject<TileEntityType<CoolerBoxTile>> COOLER_BOX = SushiContent.tile("cooler_box", CoolerBoxTile::new, Blocks.COOLER_BOX);
        public static RegistryObject<TileEntityType<FermentationBarrelTile>> FERMENTATION_BARREL = SushiContent.tile("fermentation_barrel", FermentationBarrelTile::new, Blocks.FERMENTATION_BARREL);
    }

    public static class Items {
        public static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"sushigocrafting");
        public static final RegistryObject<BlockItem> RICE_SEEDS = SushiContent.blockItem("rice_seeds", Blocks.RICE_CROP);
        public static final RegistryObject<Item> RICE = SushiContent.basicItem("rice", "plant");
        public static final RegistryObject<BlockItem> CUCUMBER_SEEDS = SushiContent.blockItem("cucumber_seeds", Blocks.CUCUMBER_CROP);
        public static final RegistryObject<Item> CUCUMBER = SushiContent.basicItem("cucumber", "plant");
        public static final RegistryObject<BlockItem> SOY_SEEDS = SushiContent.blockItem("soy_seeds", Blocks.SOY_CROP);
        public static final RegistryObject<Item> SOY_BEAN = SushiContent.basicItem("soy_bean", "plant");
        public static final RegistryObject<BlockItem> WASABI_SEEDS = SushiContent.blockItem("wasabi_seeds", Blocks.WASABI_CROP);
        public static final RegistryObject<Item> WASABI_ROOT = SushiContent.basicItem("wasabi_root", "plant");
        public static final RegistryObject<BlockItem> SESAME_SEEDS = SushiContent.blockItem("sesame_seeds", Blocks.SESAME_CROP);
        public static final RegistryObject<BlockItem> SEAWEED = SushiContent.blockItem("seaweed", Blocks.SEAWEED);
        public static final RegistryObject<Item> DRY_SEAWEED = SushiContent.basicItem("dried_seaweed", "");
        public static final RegistryObject<BlockItem> SEAWEED_BLOCK = SushiContent.blockItem("dried_seaweed_block", Blocks.SEAWEED_BLOCK);
        public static final RegistryObject<Item> SEAWEED_ON_A_STICK = SushiContent.basicItem("seaweed_on_a_stick", "");
        public static final RegistryObject<Item> RAW_TUNA = SushiContent.basicItem("raw_tuna", "");
        public static final RegistryObject<Item> AVOCADO = SushiContent.basicItem("avocado", "plant");
        public static final RegistryObject<BlockItem> AVOCADO_LOG = SushiContent.blockItem("avocado_log", Blocks.AVOCADO_LOG);
        public static final RegistryObject<BlockItem> AVOCADO_LEAVES = SushiContent.blockItem("avocado_leaves", Blocks.AVOCADO_LEAVES);
        public static final RegistryObject<BlockItem> AVOCADO_LEAVES_LOG = SushiContent.blockItem("avocado_leaves_logged", Blocks.AVOCADO_LEAVES_LOG);
        public static final RegistryObject<BlockItem> AVOCADO_SAPLING = SushiContent.blockItem("avocado_sapling", Blocks.AVOCADO_SAPLING);
        public static final RegistryObject<BlockItem> ROLLER = SushiContent.blockItem("roller", Blocks.ROLLER);
        public static final RegistryObject<BlockItem> RICE_COOKER = SushiContent.blockItem("rice_cooker", Blocks.RICE_COOKER);
        public static final RegistryObject<BlockItem> CUTTING_BOARD = SushiContent.blockItem("cutting_board", Blocks.CUTTING_BOARD);
        public static final RegistryObject<BlockItem> COOLER_BOX = SushiContent.blockItem("cooler_box", Blocks.COOLER_BOX, new Item.Properties().func_200917_a(1));
        public static final RegistryObject<BlockItem> FERMENTATION_BARREL = SushiContent.blockItem("fermentation_barrel", Blocks.FERMENTATION_BARREL);
        public static final RegistryObject<AmountItem> AVOCADO_SLICES = SushiContent.amountItem("avocado_slices", "ingredient", 100, 500, 1000, false);
        public static final RegistryObject<AmountItem> RAW_TUNA_FILLET = SushiContent.amountItem("tuna_fillet", "ingredient", 1000, 3000, 6000, false);
        public static final RegistryObject<AmountItem> RAW_SALMON_FILLET = SushiContent.amountItem("salmon_fillet", "ingredient", 500, 2000, 4000, false);
        public static final RegistryObject<Item> NORI_SHEET = SushiContent.basicItem("nori_sheets", "ingredient");
        public static final RegistryObject<AmountItem> COOKED_RICE = SushiContent.amountItem("cooked_rice", "ingredient", 50, 500, 2000, false);
        public static final RegistryObject<AmountItem> CUCUMBER_SLICES = SushiContent.amountItem("cucumber_slices", "ingredient", 50, 200, 400, false);
        public static final RegistryObject<AmountItem> IMITATION_CRAB = SushiContent.amountItem("imitation_crab", "ingredient", 50, 200, 400, false);
        public static final RegistryObject<AmountItem> SESAME_SEED = SushiContent.amountItem("sesame_seed", "ingredient", 10, 100, 200, false);
        public static final RegistryObject<AmountItem> TOBIKO = SushiContent.amountItem("tobiko", "ingredient", 10, 50, 100, false);
        public static final RegistryObject<AmountItem> CHEESE = SushiContent.amountItem("cheese", "ingredient", 50, 250, 500, false);
        public static final RegistryObject<AmountItem> SHRIMP = SushiContent.amountItem("shrimp", "ingredient", 20, 50, 100, false);
        public static final RegistryObject<AmountItem> SOY_SAUCE = SushiContent.amountItem("soy_sauce", "ingredient", 10, 50, 100, true);
        public static final RegistryObject<AmountItem> WASABI_PASTE = SushiContent.amountItem("wasabi_paste", "ingredient", 10, 50, 100, true);
        public static final RegistryObject<Item> KNIFE_CLEAVER = SushiContent.basicItem("cleaver_knife", "");
        public static final RegistryObject<Item> TUNA_BUCKET = SushiContent.item("tuna_bucket", () -> new FishBucketItem(EntityTypes.TUNA, () -> Fluids.field_204546_a, new Item.Properties().func_200917_a(1).func_200916_a(SushiGoCrafting.TAB)));
        public static final RegistryObject<Item> SHRIMP_BUCKET = SushiContent.item("shrimp_bucket", () -> new FishBucketItem(EntityTypes.SHRIMP, () -> Fluids.field_204546_a, new Item.Properties().func_200917_a(1).func_200916_a(SushiGoCrafting.TAB)));
    }

    public static class Blocks {
        public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"sushigocrafting");
        public static final RegistryObject<CustomCropBlock> RICE_CROP = SushiContent.block("rice_crop", () -> new WaterCropBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)net.minecraft.block.Blocks.field_203215_jy), (Supplier<? extends Item>)Items.RICE_SEEDS, state -> state.func_203425_a(net.minecraft.block.Blocks.field_150346_d)));
        public static final RegistryObject<CustomCropBlock> CUCUMBER_CROP = SushiContent.block("cucumber_crop", () -> new CustomCropBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)net.minecraft.block.Blocks.field_150464_aj), (Supplier<? extends Item>)Items.CUCUMBER_SEEDS, state -> state.func_203425_a(net.minecraft.block.Blocks.field_150458_ak)));
        public static final RegistryObject<CustomCropBlock> SOY_CROP = SushiContent.block("soy_crop", () -> new CustomCropBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)net.minecraft.block.Blocks.field_150464_aj), (Supplier<? extends Item>)Items.SOY_SEEDS, state -> state.func_203425_a(net.minecraft.block.Blocks.field_150458_ak)));
        public static final RegistryObject<CustomCropBlock> WASABI_CROP = SushiContent.block("wasabi_crop", () -> new CustomCropBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)net.minecraft.block.Blocks.field_150464_aj), (Supplier<? extends Item>)Items.WASABI_SEEDS, state -> state.func_203425_a(net.minecraft.block.Blocks.field_150458_ak)));
        public static final RegistryObject<CustomCropBlock> SESAME_CROP = SushiContent.block("sesame_crop", () -> new CustomCropBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)net.minecraft.block.Blocks.field_150464_aj), (Supplier<? extends Item>)Items.SESAME_SEEDS, state -> state.func_203425_a(net.minecraft.block.Blocks.field_150458_ak)));
        public static final RegistryObject<Block> SEAWEED = SushiContent.block("seaweed", () -> new SeaWeedTopBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_203243_f).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        public static final RegistryObject<Block> SEAWEED_PLANT = SushiContent.block("seaweed_plant", () -> new SeaWeedBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_203243_f).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        public static final RegistryObject<Block> SEAWEED_BLOCK = SushiContent.block("dried_seaweed_block", () -> new SushiGoCraftingBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)net.minecraft.block.Blocks.field_203216_jz)){

            public PushReaction func_149656_h(BlockState state) {
                return PushReaction.DESTROY;
            }
        });
        public static final RegistryObject<RotatedPillarBlock> AVOCADO_LOG = SushiContent.block("avocado_log", () -> new AvocadoLogBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)net.minecraft.block.Blocks.field_196626_Q)));
        public static final RegistryObject<RotatedPillarBlock> AVOCADO_LEAVES_LOG = SushiContent.block("avocado_leaves_logged", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)net.minecraft.block.Blocks.field_196626_Q).func_226896_b_()));
        public static final RegistryObject<Block> AVOCADO_LEAVES = SushiContent.block("avocado_leaves", AvocadoLeavesBlock::new);
        public static final RegistryObject<Block> AVOCADO_SAPLING = SushiContent.block("avocado_sapling", () -> new SaplingBlock((Tree)new AvocadoTree(), AbstractBlock.Properties.func_200950_a((AbstractBlock)net.minecraft.block.Blocks.field_196674_t)));
        public static final RegistryObject<RollerBlock> ROLLER = SushiContent.block("roller", RollerBlock::new);
        public static final RegistryObject<RiceCookerBlock> RICE_COOKER = SushiContent.block("rice_cooker", RiceCookerBlock::new);
        public static final RegistryObject<CuttingBoardBlock> CUTTING_BOARD = SushiContent.block("cutting_board", CuttingBoardBlock::new);
        public static final RegistryObject<CoolerBoxBlock> COOLER_BOX = SushiContent.block("cooler_box", CoolerBoxBlock::new);
        public static final RegistryObject<FermentationBarrelBlock> FERMENTATION_BARREL = SushiContent.block("fermentation_barrel", FermentationBarrelBlock::new);
    }
}

