/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.tile.machinery;

import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.buuz135.sushigocrafting.recipe.CuttingBoardRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.RecipeUtil;
import com.hrznstudio.titanium.util.TagUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class CuttingBoardTile
extends ActiveTile<CuttingBoardTile> {
    public static ITag<Item> KNIFE = TagUtil.getItemTag((ResourceLocation)new ResourceLocation("forge", "tools/knife"));
    @Save
    private InventoryComponent<CuttingBoardTile> input = new InventoryComponent("input", 0, 0, 1).setInputFilter((stack, integer) -> this.accepts((ItemStack)stack));
    @Save
    private int click;

    public CuttingBoardTile() {
        super((BasicTileBlock)SushiContent.Blocks.CUTTING_BOARD.get());
        this.addInventory(this.input);
        this.click = 0;
    }

    public ActionResultType onActivated(PlayerEntity player, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            if (!this.input.getStackInSlot(0).func_190926_b() && stack.func_77973_b().func_206844_a(KNIFE)) {
                ++this.click;
                if (this.click > 5) {
                    for (CuttingBoardRecipe recipe : RecipeUtil.getRecipes((World)this.field_145850_b, (IRecipeType)CuttingBoardRecipe.SERIALIZER.getRecipeType())) {
                        if (!recipe.getInput().test(this.input.getStackInSlot(0))) continue;
                        Item item = FoodAPI.get().getIngredientFromName(recipe.getIngredient()).getItem();
                        if (item instanceof AmountItem) {
                            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)((AmountItem)item).random(player, this.field_145850_b));
                        } else {
                            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)item));
                        }
                        this.input.getStackInSlot(0).func_190918_g(1);
                    }
                    this.click = 0;
                }
                this.syncObject(this.click);
                return ActionResultType.SUCCESS;
            }
            if (this.input.getStackInSlot(0).func_190926_b() && this.accepts(stack)) {
                this.input.insertItem(0, stack.func_77946_l(), false);
                stack.func_190920_e(0);
                return ActionResultType.SUCCESS;
            }
        } else if (player.func_225608_bj_()) {
            ItemStack inserted = this.input.getStackInSlot(0).func_77946_l();
            this.input.setStackInSlot(0, ItemStack.field_190927_a);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)inserted);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @Nonnull
    public CuttingBoardTile getSelf() {
        return this;
    }

    public InventoryComponent<CuttingBoardTile> getInput() {
        return this.input;
    }

    public int getClick() {
        return this.click;
    }

    private boolean accepts(ItemStack input) {
        return RecipeUtil.getRecipes((World)this.field_145850_b, (IRecipeType)CuttingBoardRecipe.SERIALIZER.getRecipeType()).stream().anyMatch(cuttingBoardRecipe -> cuttingBoardRecipe.getInput().test(input));
    }
}

