/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.compat.jei.categories;

import com.buuz135.sushigocrafting.block.machinery.RollerBlock;
import com.buuz135.sushigocrafting.client.gui.RollerWeightSelectorButtonComponent;
import com.buuz135.sushigocrafting.client.gui.provider.RollerAssetProvider;
import com.buuz135.sushigocrafting.item.FoodItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.hrznstudio.titanium.client.screen.addon.SlotsScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;

public class RollerCategory
implements IRecipeCategory<Recipe> {
    public static ResourceLocation UID = new ResourceLocation("sushigocrafting", "roller");
    private final IGuiHelper guiHelper;

    public RollerCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent(((RollerBlock)SushiContent.Blocks.ROLLER.get()).m_7705_());
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(new ResourceLocation("sushigocrafting", "textures/gui/roller.png"), 8, 17, 160, 79);
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(Recipe recipe, IIngredients iIngredients) {
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)recipe.stack));
        iIngredients.setInputs(VanillaTypes.ITEM, recipe.stack.getIngredientList().stream().filter(iFoodIngredient -> !iFoodIngredient.isEmpty()).map(iFoodIngredient -> new ItemStack((ItemLike)iFoodIngredient.getItem())).collect(Collectors.toList()));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup stackGroup = iRecipeLayout.getItemStacks();
        stackGroup.init(0, false, 4, 2);
        stackGroup.set(0, new ItemStack((ItemLike)recipe.stack));
        for (int i = 0; i < recipe.stack.getIngredientList().size(); ++i) {
            if (recipe.stack.getIngredientList().get(i).isEmpty()) continue;
            stackGroup.init(i + 1, true, (Integer)recipe.stack.getType().getSlotPosition().apply(i).getLeft() - 8, (Integer)recipe.stack.getType().getSlotPosition().apply(i).getRight() - 18);
            stackGroup.set(i + 1, new ItemStack((ItemLike)recipe.stack.getIngredientList().get(i).getItem()));
        }
    }

    public void draw(Recipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        SlotsScreenAddon.drawAsset((PoseStack)matrixStack, (Screen)Minecraft.m_91087_().f_91080_, (IAssetProvider)RollerAssetProvider.INSTANCE, (int)5, (int)3, (int)0, (int)0, (int)1, integer -> Pair.of((Object)0, (Object)0), integer -> ItemStack.f_41583_, (boolean)true, integer -> new Color(DyeColor.ORANGE.m_41070_()), integer -> true);
        SlotsScreenAddon.drawAsset((PoseStack)matrixStack, (Screen)Minecraft.m_91087_().f_91080_, (IAssetProvider)RollerAssetProvider.INSTANCE, (int)-7, (int)-17, (int)0, (int)0, (int)recipe.stack.getIngredientList().size(), recipe.stack.getType().getSlotPosition(), integer -> ItemStack.f_41583_, (boolean)true, integer -> new Color(DyeColor.LIGHT_BLUE.m_41070_()), integer -> true);
        for (int i = 0; i < recipe.stack.getIngredientList().size(); ++i) {
            RollerWeightSelectorButtonComponent.drawBackground(matrixStack, Minecraft.m_91087_().f_91080_, RollerAssetProvider.INSTANCE, 0, 0, (Integer)recipe.stack.getType().getSlotPosition().apply(i).getLeft() - 8 + 18, (Integer)recipe.stack.getType().getSlotPosition().apply(i).getRight() - 18);
            RollerWeightSelectorButtonComponent.drawForeground(matrixStack, Minecraft.m_91087_().f_91080_, RollerAssetProvider.INSTANCE, 0, 0, (Integer)recipe.stack.getType().getSlotPosition().apply(i).getLeft() - 8 + 18, (Integer)recipe.stack.getType().getSlotPosition().apply(i).getRight() - 18, Integer.MIN_VALUE, 18, recipe.stack.getType().getName(), i);
        }
    }

    public static class Recipe {
        private final FoodItem stack;

        public Recipe(FoodItem stack) {
            this.stack = stack;
        }
    }
}

