/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.tile.machinery;

import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.buuz135.sushigocrafting.recipe.FermentingBarrelRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.util.RecipeUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FermentationBarrelTile
extends ActiveTile<FermentationBarrelTile> {
    @Save
    private ProgressBarComponent<FermentationBarrelTile> bar = new ProgressBarComponent(93, 48, 100).setCanIncrease(FermentationBarrelTile::canStart).setCanReset(FermentationBarrelTile::canStart).setOnTickWork(() -> this.syncObject(this.bar)).setBarDirection(ProgressBarComponent.BarDirection.ARROW_RIGHT).setOnFinishWork(() -> {
        this.onFinish();
        this.syncObject(this.bar);
        this.m_6596_();
    });
    @Save
    private final FluidTankComponent<FermentationBarrelTile> fluid;
    @Save
    private final InventoryComponent<FermentationBarrelTile> input;
    @Save
    private final InventoryComponent<FermentationBarrelTile> output;

    public FermentationBarrelTile(BlockPos pos, BlockState state) {
        super((BasicTileBlock)SushiContent.Blocks.FERMENTATION_BARREL.get(), pos, state);
        this.addProgressBar(this.bar);
        this.input = new InventoryComponent("input", 30, 48, 1).setSlotToColorRender(0, DyeColor.BLUE).setOutputFilter((i, s) -> false);
        this.addInventory(this.input);
        this.output = new InventoryComponent("output", 130, 48, 1).setSlotToColorRender(0, DyeColor.ORANGE).setInputFilter((i, s) -> false);
        this.addInventory(this.output);
        this.fluid = new FluidTankComponent("fluid", 2000, 59, 46).setTankType(FluidTankComponent.Type.SMALL).setTankAction(FluidTankComponent.Action.FILL);
        this.addTank(this.fluid);
    }

    @Nonnull
    public FermentationBarrelTile getSelf() {
        return this;
    }

    public InteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        InteractionResult type = super.onActivated(player, hand, facing, hitX, hitY, hitZ);
        if (!type.m_19080_()) {
            this.openGui(player);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public boolean canStart() {
        return RecipeUtil.getRecipes((Level)this.f_58857_, (RecipeType)FermentingBarrelRecipe.SERIALIZER.getRecipeType()).stream().anyMatch(fermentingBarrelRecipe -> fermentingBarrelRecipe.input.test(this.input.getStackInSlot(0)) && (fermentingBarrelRecipe.fluid.isEmpty() || fermentingBarrelRecipe.fluid.isFluidEqual(this.fluid.getFluid()) && this.fluid.getFluid().getAmount() >= fermentingBarrelRecipe.fluid.getAmount()) && this.output.getStackInSlot(0).m_41619_());
    }

    public void onFinish() {
        RecipeUtil.getRecipes((Level)this.f_58857_, (RecipeType)FermentingBarrelRecipe.SERIALIZER.getRecipeType()).stream().filter(fermentingBarrelRecipe -> fermentingBarrelRecipe.input.test(this.input.getStackInSlot(0)) && (fermentingBarrelRecipe.fluid.isEmpty() || fermentingBarrelRecipe.fluid.isFluidEqual(this.fluid.getFluid()) && this.fluid.getFluid().getAmount() >= fermentingBarrelRecipe.fluid.getAmount()) && this.output.getStackInSlot(0).m_41619_()).findFirst().ifPresent(fermentingBarrelRecipe -> {
            this.input.getStackInSlot(0).m_41774_(1);
            this.fluid.drainForced(fermentingBarrelRecipe.getFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            if (fermentingBarrelRecipe.output.m_41720_() instanceof AmountItem) {
                ItemHandlerHelper.insertItem(this.output, (ItemStack)((AmountItem)fermentingBarrelRecipe.output.m_41720_()).random(null, this.f_58857_), (boolean)false);
            } else {
                ItemHandlerHelper.insertItem(this.output, (ItemStack)fermentingBarrelRecipe.output.m_41777_(), (boolean)false);
            }
        });
    }

    public ProgressBarComponent<FermentationBarrelTile> getBar() {
        return this.bar;
    }
}

