/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.loot;

import com.buuz135.sushigocrafting.loot.ItemWeightedItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class SeedsLootModifier
extends LootModifier {
    private final List<ItemWeightedItem> seeds = new ArrayList<ItemWeightedItem>();

    public SeedsLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
        this.seeds.add(new ItemWeightedItem(Items.f_42404_, 150));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.RICE_SEEDS.get(), 25));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.SESAME_SEEDS.get(), 10));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.WASABI_SEEDS.get(), 25));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.SOY_SEEDS.get(), 25));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.CUCUMBER_SEEDS.get(), 25));
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ArrayList<ItemStack> customLoot = new ArrayList<ItemStack>();
        for (ItemStack stack : generatedLoot) {
            if (stack.m_41720_() == Items.f_42404_) {
                WeightedRandom.m_146317_((Random)context.m_78933_(), this.seeds).ifPresent(itemWeightedItem -> {
                    ItemStack weightedStack = new ItemStack((ItemLike)itemWeightedItem.getStack());
                    weightedStack.m_41764_(stack.m_41613_());
                    customLoot.add(weightedStack);
                });
                continue;
            }
            customLoot.add(stack);
        }
        return customLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<SeedsLootModifier> {
        public SeedsLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            return new SeedsLootModifier(ailootcondition);
        }

        public JsonObject write(SeedsLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

