/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import com.hrznstudio.titanium._impl.TagConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.SetTag;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class TagUtil {
    public static <T> boolean hasTag(T type, SetTag<T> tag) {
        return tag.m_8110_(type);
    }

    public static TagCollection<Block> getAllBlockTags(Level world) {
        return world.m_5999_().m_144452_(Registry.f_122901_);
    }

    public static TagCollection<Item> getAllItemTags(Level world) {
        return world.m_5999_().m_144452_(Registry.f_122904_);
    }

    public static TagCollection<Fluid> getAllFluidTags(Level world) {
        return world.m_5999_().m_144452_(Registry.f_122899_);
    }

    public static <T> Collection<T> getAllEntries(SetTag<T> ... tags) {
        if (tags.length == 0) {
            return Collections.emptyList();
        }
        if (tags.length == 1) {
            return tags[0].m_6497_();
        }
        ArrayList list = new ArrayList();
        for (SetTag<T> tag : tags) {
            list.addAll(tag.m_6497_());
        }
        return list;
    }

    public static <T> Collection<T> getAllEntries(SetTag<T> tag) {
        return tag.m_6497_();
    }

    public static <T> Tag<T> getOrCreateTag(TagCollection<T> collection, ResourceLocation resourceLocation) {
        if (collection.m_13406_().contains(resourceLocation)) {
            return collection.m_13404_(resourceLocation);
        }
        return collection.m_7689_(resourceLocation);
    }

    public static Tag<Item> getItemTag(ResourceLocation resourceLocation) {
        if (ItemTags.m_13193_().m_13406_().contains(resourceLocation)) {
            return ItemTags.m_13193_().m_13404_(resourceLocation);
        }
        return ItemTags.m_13194_((String)resourceLocation.toString());
    }

    public static Tag<Block> getBlockTag(ResourceLocation resourceLocation) {
        if (BlockTags.m_13115_().m_13406_().contains(resourceLocation)) {
            return BlockTags.m_13115_().m_13404_(resourceLocation);
        }
        return BlockTags.m_13116_((String)resourceLocation.toString());
    }

    public static Tag<EntityType<?>> getEntityTypeTag(ResourceLocation resourceLocation) {
        if (EntityTypeTags.m_13126_().m_13406_().contains(resourceLocation)) {
            return EntityTypeTags.m_13126_().m_13404_(resourceLocation);
        }
        return EntityTypeTags.m_13127_((String)resourceLocation.toString());
    }

    public static Tag<Fluid> getFluidTag(ResourceLocation resourceLocation) {
        if (FluidTags.m_144299_().m_13406_().contains(resourceLocation)) {
            return FluidTags.m_144299_().m_13404_(resourceLocation);
        }
        return FluidTags.m_13134_((String)resourceLocation.toString());
    }

    public static ItemStack getItemWithPreference(Tag<Item> tag) {
        if (tag.m_6497_().isEmpty()) {
            return ItemStack.f_41583_;
        }
        List elements = tag.m_6497_();
        for (String modid : TagConfig.ITEM_PREFERENCE) {
            for (Item allElement : elements) {
                if (!allElement.getRegistryName().m_135827_().equalsIgnoreCase(modid)) continue;
                return new ItemStack((ItemLike)allElement);
            }
        }
        return new ItemStack((ItemLike)elements.get(0));
    }
}

