/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.api.impl;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IIngredientConsumer;
import com.buuz135.sushigocrafting.api.IIngredientEffect;
import com.buuz135.sushigocrafting.api.impl.DietType;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.api.impl.effect.AddIngredientEffect;
import com.buuz135.sushigocrafting.api.impl.effect.ModifyIngredientEffect;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FoodIngredient
implements IFoodIngredient {
    public static FoodIngredient EMPTY = new FoodIngredient("empty", null, 0, IIngredientConsumer.WEIGHT, null, null, 0, 0, DietType.SUGARS);
    public static FoodIngredient RICE = new FoodIngredient("rice", (Supplier<? extends Item>)SushiContent.Items.COOKED_RICE, 30, IIngredientConsumer.WEIGHT, null, new ModifyIngredientEffect(1.75f, 0), 0, 2, DietType.GRAINS);
    public static FoodIngredient NORI = new FoodIngredient("nori", (Supplier<? extends Item>)SushiContent.Items.NORI_SHEET, 1, IIngredientConsumer.STACK, null, null, 1, 1, DietType.VEGETABLES);
    public static FoodIngredient TUNA_FILLET = new FoodIngredient("tuna", (Supplier<? extends Item>)SushiContent.Items.RAW_TUNA_FILLET, 30, IIngredientConsumer.WEIGHT, () -> Ingredient.m_43911_((Tag)ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "raw_fishes/tuna"))), new AddIngredientEffect((Supplier<MobEffect>)SushiContent.Effects.ACQUIRED_TASTE, 30, 0), 3, 1, DietType.PROTEINS);
    public static FoodIngredient SALMON_FILLET = new FoodIngredient("salmon", (Supplier<? extends Item>)SushiContent.Items.RAW_SALMON_FILLET, 30, IIngredientConsumer.WEIGHT, () -> Ingredient.m_43911_((Tag)ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "raw_fishes/salmon"))), new AddIngredientEffect((Supplier<MobEffect>)SushiContent.Effects.SMALL_BITES, 30, 0), 3, 1, DietType.PROTEINS);
    public static FoodIngredient AVOCADO = new FoodIngredient("avocado", (Supplier<? extends Item>)SushiContent.Items.AVOCADO_SLICES, 45, IIngredientConsumer.WEIGHT, () -> Ingredient.m_43911_((Tag)ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "fruits/avocado"))), new ModifyIngredientEffect(1.2f, 1), 2, 2, DietType.FRUITS);
    public static FoodIngredient CUCUMBER = new FoodIngredient("cucumber", (Supplier<? extends Item>)SushiContent.Items.CUCUMBER_SLICES, 15, IIngredientConsumer.WEIGHT, () -> Ingredient.m_43911_((Tag)ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "crops/cucumber"))), new ModifyIngredientEffect(1.25f, 0), 2, 2, DietType.VEGETABLES);
    public static FoodIngredient SESAME = new FoodIngredient("sesame", (Supplier<? extends Item>)SushiContent.Items.SESAME_SEED, 6, IIngredientConsumer.WEIGHT, null, new ModifyIngredientEffect(2.0f, 0), 1, 1, DietType.GRAINS);
    public static FoodIngredient CRAB = new FoodIngredient("crab", (Supplier<? extends Item>)SushiContent.Items.IMITATION_CRAB, 30, IIngredientConsumer.WEIGHT, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_}), new AddIngredientEffect(() -> MobEffects.f_19596_, 3, 0), 2, 1, DietType.PROTEINS);
    public static FoodIngredient WAKAME = new FoodIngredient("wakame", () -> Items.f_41867_, 1, IIngredientConsumer.STACK, null, null, 0, 1, DietType.VEGETABLES);
    public static FoodIngredient TOBIKO = new FoodIngredient("tobiko", (Supplier<? extends Item>)SushiContent.Items.TOBIKO, 12, IIngredientConsumer.WEIGHT, null, new ModifyIngredientEffect(1.5f, 0), 1, 2, DietType.PROTEINS);
    public static FoodIngredient CHEESE = new FoodIngredient("cheese", (Supplier<? extends Item>)SushiContent.Items.CHEESE, 12, IIngredientConsumer.WEIGHT, null, new AddIngredientEffect(() -> MobEffects.f_19618_, 15, 0), 1, 2, DietType.PROTEINS);
    public static FoodIngredient SHRIMP = new FoodIngredient("shrimp", (Supplier<? extends Item>)SushiContent.Items.SHRIMP, 30, IIngredientConsumer.WEIGHT, null, new AddIngredientEffect((Supplier<MobEffect>)SushiContent.Effects.STEADY_HANDS, 60, 0), 2, 1, DietType.PROTEINS);
    public static FoodIngredient CHICKEN = new FoodIngredient("chicken", () -> Items.f_42582_, 30, IIngredientConsumer.WEIGHT, null, new AddIngredientEffect(() -> MobEffects.f_19591_, 10, 0), 2, 1, DietType.PROTEINS);
    public static FoodIngredient SOY_SAUCE = new FoodIngredient("soy_sauce", (Supplier<? extends Item>)SushiContent.Items.SOY_SAUCE, 4, IIngredientConsumer.WEIGHT, null, new ModifyIngredientEffect(1.0f, 1), 0, 0, DietType.GRAINS);
    public static FoodIngredient WASABI = new FoodIngredient("wasabi", (Supplier<? extends Item>)SushiContent.Items.WASABI_PASTE, 4, IIngredientConsumer.WEIGHT, () -> Ingredient.m_43911_((Tag)ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "crops/wasabi_root"))), new AddIngredientEffect(() -> MobEffects.f_19607_, 10, 0), 0, 0, DietType.VEGETABLES);
    private final Supplier<? extends Item> item;
    private final String name;
    private final int defaultAmount;
    private final IIngredientConsumer ingredientConsumer;
    private final Supplier<Ingredient> ingredientSupplier;
    private final IIngredientEffect effect;
    private final int hungerValue;
    private final int saturationValue;
    private final DietType dietType;

    public FoodIngredient(String name, Supplier<? extends Item> item, int defaultAmount, IIngredientConsumer ingredientConsumer, Supplier<Ingredient> ingredientSupplier, IIngredientEffect effect, int foodValue, int saturationValue, DietType dietType) {
        this.name = name;
        this.item = item;
        this.defaultAmount = defaultAmount;
        this.ingredientConsumer = ingredientConsumer;
        this.ingredientSupplier = ingredientSupplier;
        this.effect = effect;
        this.hungerValue = foodValue;
        this.saturationValue = saturationValue;
        this.dietType = dietType;
        FoodAPI.get().addFoodIngredient(this);
    }

    public static void init() {
    }

    @Override
    public Item getItem() {
        return this.item.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean needsChoppingRecipe() {
        return this.ingredientSupplier != null;
    }

    public Supplier<Ingredient> getInput() {
        return this.ingredientSupplier;
    }

    @Override
    public int getDefaultAmount() {
        return this.defaultAmount;
    }

    @Override
    public IIngredientEffect getEffect() {
        return this.effect;
    }

    @Override
    public int getHungerValue() {
        return this.hungerValue;
    }

    @Override
    public int getSaturationValue() {
        return this.saturationValue;
    }

    @Override
    public DietType getDietType() {
        return this.dietType;
    }

    @Override
    public IIngredientConsumer getIngredientConsumer() {
        return this.ingredientConsumer;
    }
}

