/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.tile.machinery;

import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.buuz135.sushigocrafting.recipe.CombineAmountItemRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CoolerBoxTile
extends ActiveTile<CoolerBoxTile> {
    @Save
    private final InventoryComponent<CoolerBoxTile> input = new InventoryComponent("input", 44, 20, 20).setRange(5, 4).setInputFilter((stack, integer) -> stack.m_41720_() instanceof AmountItem);

    public CoolerBoxTile(BlockPos pos, BlockState state) {
        super((BasicTileBlock)SushiContent.Blocks.COOLER_BOX.get(), pos, state);
        this.addInventory(this.input);
    }

    public InteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        InteractionResult type = super.onActivated(player, hand, facing, hitX, hitY, hitZ);
        if (!type.m_19080_()) {
            this.openGui(player);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, CoolerBoxTile blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        if (this.f_58857_.m_46467_() % 10L == 0L) {
            for (int current = 0; current < this.input.getSlots(); ++current) {
                for (int other = 0; other < this.input.getSlots(); ++other) {
                    ItemStack result;
                    if (current == other || !CombineAmountItemRecipe.stackMatches(this.input.getStackInSlot(current), this.input.getStackInSlot(other)) || (result = CombineAmountItemRecipe.getResult(Arrays.asList(this.input.getStackInSlot(current), this.input.getStackInSlot(other)))).m_41619_()) continue;
                    this.input.setStackInSlot(current, result);
                    this.input.setStackInSlot(other, ItemStack.f_41583_);
                    return;
                }
            }
        }
    }

    @Nonnull
    public CoolerBoxTile getSelf() {
        return this;
    }

    public InventoryComponent<CoolerBoxTile> getInput() {
        return this.input;
    }
}

