/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium._impl.test.tile;

import com.hrznstudio.titanium._impl.test.TestBlock;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.IItemStackQuery;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.redstone.IRedstoneReader;
import com.hrznstudio.titanium.api.redstone.IRedstoneState;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.redstone.RedstoneAction;
import com.hrznstudio.titanium.block.redstone.RedstoneManager;
import com.hrznstudio.titanium.block.redstone.RedstoneState;
import com.hrznstudio.titanium.block.tile.PoweredTile;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.button.RedstoneControlButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TestTile
extends PoweredTile<TestTile>
implements IRedstoneReader {
    @Save
    private ProgressBarComponent<TestTile> bar;
    @Save
    private SidedInventoryComponent<TestTile> first = (SidedInventoryComponent)new SidedInventoryComponent("test", 80, 30, 1, 0).setValidFaceModes(IFacingComponent.FaceMode.ENABLED, IFacingComponent.FaceMode.NONE).setComponentHarness(this).setInputFilter((stack, integer) -> IItemStackQuery.ANYTHING.test((ItemStack)stack));
    @Save
    private SidedInventoryComponent<TestTile> second;
    @Save
    private FluidTankComponent<TestTile> third;
    private ButtonComponent button;
    @Save
    private int state;
    @Save
    private RedstoneManager<RedstoneAction> redstoneManager;
    private RedstoneControlButtonComponent<RedstoneAction> redstoneButton;

    public TestTile(BlockPos pos, BlockState blockState) {
        super((BasicTileBlock)TestBlock.TEST.get(), pos, blockState);
        this.addInventory(this.first);
        this.second = (SidedInventoryComponent)new SidedInventoryComponent<TestTile>("test2", 80, 60, 2, 1).setComponentHarness(this).setInputFilter((stack, integer) -> IItemStackQuery.ANYTHING.test((ItemStack)stack)).setSlotToItemStackRender(0, new ItemStack((ItemLike)Items.f_42427_)).setSlotToColorRender(1, DyeColor.ORANGE);
        this.addInventory(this.second);
        this.bar = new ProgressBarComponent<TestTile>(40, 20, 500).setCanIncrease(tileEntity -> this.redstoneManager.getAction().canRun(tileEntity.getEnvironmentValue(false, null)) && this.redstoneManager.shouldWork()).setOnFinishWork(() -> {
            this.redstoneManager.finish();
            System.out.println(this.redstoneManager.getAction());
            System.out.println("WOWOOW");
        }).setBarDirection(ProgressBarComponent.BarDirection.ARROW_RIGHT).setCanReset(testTile -> this.bar.getProgress() >= this.bar.getMaxProgress()).setColor(DyeColor.LIME);
        this.addProgressBar(this.bar);
        this.third = new FluidTankComponent("testTank", 8000, 130, 30);
        this.addTank(this.third);
        this.button = new ButtonComponent(-13, 1, 14, 14){

            @Override
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new StateButtonAddon(TestTile.this.button, new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[0]), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[0]), new StateButtonInfo(2, AssetTypes.BUTTON_SIDENESS_PULL, new String[0]), new StateButtonInfo(3, AssetTypes.BUTTON_SIDENESS_PUSH, new String[0])}){

                    @Override
                    public int getState() {
                        return TestTile.this.state;
                    }
                });
            }
        }.setId(0).setPredicate((playerEntity, compoundNBT) -> {
            System.out.println(":pepeD:");
            ++this.state;
            System.out.println(this.getEnvironmentValue(false, null));
            System.out.println(this.getEnvironmentValue(true, FacingUtil.getFacingFromSide(this.getFacingDirection(), FacingUtil.Sideness.TOP)));
            if (this.state >= 4) {
                this.state = 0;
            }
            this.markForUpdate();
        });
        this.addButton(this.button);
        this.redstoneButton = new RedstoneControlButtonComponent(152, 84, 14, 14, () -> this.redstoneManager, () -> this);
        this.redstoneButton.setId(1);
        this.addButton(this.redstoneButton);
        this.first.setColor(DyeColor.LIME);
        this.second.setColor(DyeColor.CYAN);
        this.redstoneManager = new RedstoneManager<RedstoneAction>(RedstoneAction.IGNORE, false);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, TestTile blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (Objects.requireNonNull(this.m_58904_()).m_46471_()) {
            this.m_58904_().m_6106_().m_5565_(false);
        }
    }

    @Override
    public void onNeighborChanged(Block blockIn, BlockPos fromPos) {
        super.onNeighborChanged(blockIn, fromPos);
        this.redstoneManager.setLastRedstoneState(this.getEnvironmentValue(false, null).isReceivingRedstone());
    }

    @Override
    @Nonnull
    public TestTile getSelf() {
        return this;
    }

    @Override
    @ParametersAreNonnullByDefault
    public InteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(player, hand, facing, hitX, hitY, hitZ) == InteractionResult.PASS) {
            this.openGui(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nonnull
    public EnergyStorageComponent<TestTile> createEnergyStorage() {
        return new EnergyStorageComponent<TestTile>(10000, 4, 10);
    }

    @Override
    public IRedstoneState getEnvironmentValue(boolean strongPower, Direction direction) {
        if (strongPower) {
            if (direction == null) {
                return this.f_58857_.m_46753_(this.f_58858_) ? RedstoneState.ON : RedstoneState.OFF;
            }
            return this.f_58857_.m_46616_(this.f_58858_, direction) ? RedstoneState.ON : RedstoneState.OFF;
        }
        return this.f_58857_.m_46755_(this.f_58858_) > 0 ? RedstoneState.ON : RedstoneState.OFF;
    }
}

