/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.fluid;

import com.hrznstudio.titanium.fluid.TitaniumFluid;
import com.hrznstudio.titanium.module.DeferredRegistryHelper;
import com.hrznstudio.titanium.module.api.IAlternativeEntries;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TitaniumFluidInstance
extends ForgeRegistryEntry<TitaniumFluidInstance>
implements IAlternativeEntries {
    private TitaniumFluid flowingFluid;
    private TitaniumFluid sourceFluid;
    private Item bucketFluid;
    private Block blockFluid;
    private final String fluid;

    public TitaniumFluidInstance(String modid, String fluid, FluidAttributes.Builder attributes, boolean hasBucket, CreativeModeTab group) {
        this.fluid = fluid;
        this.sourceFluid = new TitaniumFluid.Source(attributes);
        this.flowingFluid = new TitaniumFluid.Flowing(attributes);
        this.sourceFluid = this.sourceFluid.setSourceFluid(this.sourceFluid).setFlowingFluid((Fluid)this.flowingFluid);
        this.flowingFluid = this.flowingFluid.setSourceFluid(this.sourceFluid).setFlowingFluid((Fluid)this.flowingFluid);
        if (hasBucket) {
            this.bucketFluid = new BucketItem((Fluid)this.sourceFluid, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(group));
        }
        this.blockFluid = new LiquidBlock(this.sourceFluid, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_60993_()){};
        this.sourceFluid.setBlockFluid(this.blockFluid).setBucketFluid(this.bucketFluid);
        this.flowingFluid.setBlockFluid(this.blockFluid).setBucketFluid(this.bucketFluid);
    }

    @Override
    public void addAlternatives(DeferredRegistryHelper registry) {
        registry.register(Fluid.class, this.fluid + "_fluid", () -> this.flowingFluid);
        registry.register(Fluid.class, this.fluid, () -> this.sourceFluid);
        registry.register(Block.class, this.fluid, () -> this.blockFluid);
        if (this.bucketFluid != null) {
            registry.register(Item.class, this.fluid + "_bucket", () -> this.bucketFluid);
        }
    }

    public TitaniumFluid getFlowingFluid() {
        return this.flowingFluid;
    }

    public TitaniumFluid getSourceFluid() {
        return this.sourceFluid;
    }

    public Item getBucketFluid() {
        return this.bucketFluid;
    }

    public Block getBlockFluid() {
        return this.blockFluid;
    }

    public void setBucketFluid(Item bucketFluid) {
        this.bucketFluid = bucketFluid;
        this.sourceFluid.setBucketFluid(bucketFluid);
        this.flowingFluid.setBucketFluid(bucketFluid);
    }
}

