/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.module;

import com.hrznstudio.titanium.module.api.IAlternativeEntries;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class DeferredRegistryHelper {
    private final String modId;
    private HashMap<Class<? extends IForgeRegistryEntry>, DeferredRegister<? extends IForgeRegistryEntry>> registries;

    public DeferredRegistryHelper(String modId) {
        this.modId = modId;
        this.registries = new HashMap();
    }

    public <T extends IForgeRegistryEntry> DeferredRegister<? super T> addRegistry(Class<T> cl) {
        DeferredRegister deferredRegister = DeferredRegister.create(cl, (String)this.modId);
        deferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus());
        return deferredRegister;
    }

    public <T extends IForgeRegistryEntry<? super T>> RegistryObject<T> register(Class<T> cl, String name, Supplier<T> object) {
        DeferredRegister deferredRegister = this.registries.computeIfAbsent(cl, this::addRegistry);
        Object j = object.get();
        if (j instanceof IAlternativeEntries) {
            ((IAlternativeEntries)j).addAlternatives(this);
        }
        return deferredRegister.register(name, () -> j);
    }

    public RegistryObject<BlockEntityType<?>> registerBlockEntityType(String name, Supplier<?> object) {
        DeferredRegister deferredRegister = this.registries.computeIfAbsent(BlockEntityType.class, this::addRegistry);
        return deferredRegister.register(name, object);
    }

    public RegistryObject<EntityType<?>> registerEntityType(String name, Supplier<?> object) {
        DeferredRegister deferredRegister = this.registries.computeIfAbsent(EntityType.class, this::addRegistry);
        return deferredRegister.register(name, object);
    }
}

