/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting;

import com.buuz135.sushigocrafting.api.IFoodType;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.api.impl.FoodHelper;
import com.buuz135.sushigocrafting.cap.ISushiWeightDiscovery;
import com.buuz135.sushigocrafting.cap.SushiDiscoveryProvider;
import com.buuz135.sushigocrafting.cap.SushiWeightDiscoveryCapability;
import com.buuz135.sushigocrafting.client.ClientProxy;
import com.buuz135.sushigocrafting.datagen.SushiBlockTagsProvider;
import com.buuz135.sushigocrafting.datagen.SushiBlockstateProvider;
import com.buuz135.sushigocrafting.datagen.SushiItemModelProvider;
import com.buuz135.sushigocrafting.datagen.SushiItemTagsProvider;
import com.buuz135.sushigocrafting.datagen.SushiLangProvider;
import com.buuz135.sushigocrafting.datagen.SushiLootTableProvider;
import com.buuz135.sushigocrafting.datagen.SushiModelProvider;
import com.buuz135.sushigocrafting.datagen.SushiRecipeProvider;
import com.buuz135.sushigocrafting.datagen.SushiSerializableProvider;
import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.network.CapabilitySyncMessage;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.buuz135.sushigocrafting.recipe.CombineAmountItemRecipe;
import com.buuz135.sushigocrafting.recipe.CuttingBoardRecipe;
import com.buuz135.sushigocrafting.recipe.FermentingBarrelRecipe;
import com.buuz135.sushigocrafting.tile.machinery.CoolerBoxTile;
import com.buuz135.sushigocrafting.tile.machinery.CuttingBoardTile;
import com.buuz135.sushigocrafting.tile.machinery.FermentationBarrelTile;
import com.buuz135.sushigocrafting.tile.machinery.RiceCookerTile;
import com.buuz135.sushigocrafting.tile.machinery.RollerTile;
import com.buuz135.sushigocrafting.world.SeaWeedFeatureHolders;
import com.buuz135.sushigocrafting.world.SushiTab;
import com.buuz135.sushigocrafting.world.tree.AvocadoTree;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardGiver;
import com.hrznstudio.titanium.reward.RewardManager;
import java.net.URL;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.data.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.PistonEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sushigocrafting")
public class SushiGoCrafting
extends ModuleController {
    public static final String MOD_ID = "sushigocrafting";
    public static final CreativeModeTab TAB = new SushiTab("sushigocrafting");
    public static NetworkHandler NETWORK = new NetworkHandler("sushigocrafting");
    public static Logger LOGGER = LogManager.getLogger((String)"sushigocrafting");

    public SushiGoCrafting() {
        FoodAPI.get();
        FoodAPI.get().init();
        SushiContent.Blocks.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        SushiContent.Items.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        SushiContent.Features.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        SushiContent.TileEntities.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        SushiContent.Effects.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        SushiContent.EntityTypes.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        SushiContent.LootSerializers.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> ClientProxy::register);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> EventManager.mod(FMLClientSetupEvent.class).process(fmlClientSetupEvent -> new ClientProxy().fmlClient((FMLClientSetupEvent)fmlClientSetupEvent)).subscribe());
        EventManager.mod(FMLCommonSetupEvent.class).process(this::fmlCommon).subscribe();
        EventManager.mod(GatherDataEvent.class).process(this::dataGen).subscribe();
        EventManager.modGeneric(RegistryEvent.Register.class, RecipeSerializer.class).process(register -> ((RegistryEvent.Register)register).getRegistry().registerAll(new IForgeRegistryEntry[]{(IForgeRegistryEntry)CombineAmountItemRecipe.SERIALIZER.setRegistryName(new ResourceLocation(MOD_ID, "amount_combine_recipe")), CuttingBoardRecipe.SERIALIZER, FermentingBarrelRecipe.SERIALIZER})).subscribe();
        EventManager.modGeneric(RegistryEvent.Register.class, Item.class).process(register -> {
            for (IFoodType value : FoodAPI.get().getFoodTypes()) {
                FoodHelper.generateFood(value).forEach(item -> {
                    Item itemConfigured = (Item)item.setRegistryName(new ResourceLocation(MOD_ID, FoodHelper.getName(item)));
                    ((RegistryEvent.Register)register).getRegistry().register((IForgeRegistryEntry)itemConfigured);
                });
            }
        }).subscribe();
        NBTManager.getInstance().scanTileClassForAnnotations(RollerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(RiceCookerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(CuttingBoardTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(CoolerBoxTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(FermentationBarrelTile.class);
        EventManager.forge(BiomeLoadingEvent.class).filter(biomeLoadingEvent -> biomeLoadingEvent.getCategory() == Biome.BiomeCategory.OCEAN).process(biomeLoadingEvent -> biomeLoadingEvent.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, SeaWeedFeatureHolders.PLACEMENT)).subscribe();
        EventManager.forge(BiomeLoadingEvent.class).filter(biomeLoadingEvent -> biomeLoadingEvent.getCategory() == Biome.BiomeCategory.OCEAN || biomeLoadingEvent.getCategory() == Biome.BiomeCategory.RIVER).process(biomeLoadingEvent -> {
            biomeLoadingEvent.getSpawns().m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)SushiContent.EntityTypes.TUNA.get(), 8, 3, 6));
            biomeLoadingEvent.getSpawns().m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)SushiContent.EntityTypes.SHRIMP.get(), 10, 6, 9));
        }).subscribe();
        EventManager.modGeneric(RegistryEvent.Register.class, EntityType.class).process(register -> {
            SpawnPlacements.m_21754_((EntityType)((EntityType)SushiContent.EntityTypes.SHRIMP.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_21400_);
            SpawnPlacements.m_21754_((EntityType)((EntityType)SushiContent.EntityTypes.TUNA.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_21400_);
        }).subscribe();
        EventManager.forge(BiomeLoadingEvent.class).filter(biomeLoadingEvent -> biomeLoadingEvent.getCategory() == Biome.BiomeCategory.PLAINS).process(biomeLoadingEvent -> biomeLoadingEvent.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, AvocadoTree.PLACEMENT)).subscribe();
        EventManager.forge(PistonEvent.Pre.class).process(pre -> {
            if (pre.getWorld().m_8055_(pre.getFaceOffsetPos()).m_60734_().equals(SushiContent.Blocks.SEAWEED_BLOCK.get()) && pre.getWorld().m_8055_(pre.getPos().m_5484_(pre.getDirection(), 2)).m_60734_().equals(Blocks.f_50075_)) {
                pre.getWorld().m_46961_(pre.getFaceOffsetPos(), false);
                NonNullList list = NonNullList.m_122779_();
                list.add((Object)new ItemStack((ItemLike)SushiContent.Items.NORI_SHEET.get(), 5 + pre.getWorld().m_5822_().nextInt(4)));
                Containers.m_19010_((Level)((Level)pre.getWorld()), (BlockPos)pre.getFaceOffsetPos().m_142022_(0.5, 0.5, 0.5), (NonNullList)list);
            }
        }).subscribe();
        EventManager.mod(EntityAttributeCreationEvent.class).process(entityAttributeCreationEvent -> {
            entityAttributeCreationEvent.put((EntityType)SushiContent.EntityTypes.TUNA.get(), AbstractFish.m_27495_().m_22265_());
            entityAttributeCreationEvent.put((EntityType)SushiContent.EntityTypes.SHRIMP.get(), AbstractFish.m_27495_().m_22265_());
        }).subscribe();
        EventManager.forge(LivingDropsEvent.class).filter(livingDropsEvent -> livingDropsEvent.getEntity() instanceof AbstractFish).process(livingDropsEvent -> {
            if (livingDropsEvent.getEntity().f_19853_.m_5822_().nextInt(10) <= 2) {
                livingDropsEvent.getDrops().add(new ItemEntity(livingDropsEvent.getEntity().f_19853_, livingDropsEvent.getEntity().m_20185_(), livingDropsEvent.getEntity().m_20186_(), livingDropsEvent.getEntity().m_20189_(), ((AmountItem)((Object)((Object)SushiContent.Items.TOBIKO.get()))).random(null, livingDropsEvent.getEntity().f_19853_)));
            }
        }).subscribe();
        RewardGiver giver = RewardManager.get().getGiver(UUID.fromString("d28b7061-fb92-4064-90fb-7e02b95a72a6"), "Buuz135");
        try {
            giver.addReward(new Reward(new ResourceLocation(MOD_ID, "back"), new URL("https://raw.githubusercontent.com/Buuz135/Industrial-Foregoing/master/contributors.json"), () -> dist -> {}, new String[]{"salmon", "tuna"}));
        }
        catch (Exception e) {
            LOGGER.catching((Throwable)e);
        }
    }

    protected void initModules() {
    }

    public void fmlCommon(FMLCommonSetupEvent event) {
        this.registerCapability();
    }

    public void dataGen(GatherDataEvent event) {
        event.getGenerator().m_123914_((DataProvider)new SushiModelProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().m_123914_((DataProvider)new SushiBlockstateProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().m_123914_((DataProvider)new SushiItemModelProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().m_123914_((DataProvider)new SushiLangProvider(event.getGenerator(), MOD_ID, "en_us"));
        SushiBlockTagsProvider provider = new SushiBlockTagsProvider(event.getGenerator(), event.getExistingFileHelper());
        event.getGenerator().m_123914_((DataProvider)provider);
        event.getGenerator().m_123914_((DataProvider)new SushiItemTagsProvider(event.getGenerator(), provider, event.getExistingFileHelper()));
        event.getGenerator().m_123914_((DataProvider)new SushiSerializableProvider(event.getGenerator(), MOD_ID));
        event.getGenerator().m_123914_((DataProvider)new SushiLootTableProvider(event.getGenerator()));
        event.getGenerator().m_123914_((DataProvider)new SushiRecipeProvider(event.getGenerator()));
    }

    private void registerCapability() {
        EventManager.mod(RegisterCapabilitiesEvent.class).process(registerCapabilitiesEvent -> registerCapabilitiesEvent.register(ISushiWeightDiscovery.class)).subscribe();
        EventManager.forgeGeneric(AttachCapabilitiesEvent.class, Entity.class).filter(attachCapabilitiesEvent -> ((AttachCapabilitiesEvent)attachCapabilitiesEvent).getObject() instanceof Player).process(attachCapabilitiesEvent -> ((AttachCapabilitiesEvent)attachCapabilitiesEvent).addCapability(new ResourceLocation(MOD_ID, "weight_discovery"), (ICapabilityProvider)new SushiDiscoveryProvider())).subscribe();
        EventManager.forge(PlayerEvent.Clone.class).process(clone -> clone.getOriginal().getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(original -> clone.getPlayer().getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(future -> {
            future.deserializeNBT((Tag)((CompoundTag)original.serializeNBT()));
            future.requestUpdate((ServerPlayer)clone.getPlayer(), ItemStack.f_41583_);
        }))).subscribe();
        EventManager.forge(PlayerEvent.PlayerLoggedInEvent.class).filter(playerLoggedInEvent -> playerLoggedInEvent.getPlayer() instanceof ServerPlayer).process(playerLoggedInEvent -> playerLoggedInEvent.getPlayer().getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(iSushiWeightDiscovery -> iSushiWeightDiscovery.requestUpdate((ServerPlayer)playerLoggedInEvent.getPlayer(), ItemStack.f_41583_))).subscribe();
    }

    static {
        ForgeMod.enableMilkFluid();
        NETWORK.registerMessage(CapabilitySyncMessage.class);
    }
}

