/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.datagen;

import com.buuz135.sushigocrafting.block.plant.CustomCropBlock;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SushiLootTableProvider
extends LootTableProvider {
    public SushiLootTableProvider(DataGenerator gen) {
        super(gen);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return Arrays.asList(Pair.of(SushiBlockLootTables::new, (Object)LootContextParamSets.f_81421_), Pair.of(() -> new SushiEntityLootTables(), (Object)LootContextParamSets.f_81415_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    private class SushiEntityLootTables
    extends EntityLoot {
        private SushiEntityLootTables() {
        }

        protected void addTables() {
            this.m_124371_((EntityType)SushiContent.EntityTypes.TUNA.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SushiContent.Items.RAW_TUNA.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42499_)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.05f))));
            this.m_124371_((EntityType)SushiContent.EntityTypes.SHRIMP.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SushiContent.Items.SHRIMP.get())))));
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return Arrays.asList((EntityType)SushiContent.EntityTypes.TUNA.get(), (EntityType)SushiContent.EntityTypes.SHRIMP.get());
        }
    }

    private static class SushiBlockLootTables
    extends BlockLoot {
        private final List<Block> knownBlocks = new ArrayList<Block>();

        private SushiBlockLootTables() {
        }

        protected void addTables() {
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.RICE_CROP, (Supplier<? extends Item>)SushiContent.Items.RICE);
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.CUCUMBER_CROP, (Supplier<? extends Item>)SushiContent.Items.CUCUMBER);
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.SOY_CROP, (Supplier<? extends Item>)SushiContent.Items.SOY_BEAN);
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.WASABI_CROP, (Supplier<? extends Item>)SushiContent.Items.WASABI_ROOT);
            this.crop((Supplier<CustomCropBlock>)SushiContent.Blocks.SESAME_CROP, (Supplier<? extends Item>)SushiContent.Items.SESAME_SEED);
            this.dropOther((Supplier<Block>)SushiContent.Blocks.SEAWEED, (Supplier<? extends ItemLike>)SushiContent.Items.SEAWEED);
            this.dropOther((Supplier<Block>)SushiContent.Blocks.SEAWEED_PLANT, (Supplier<? extends ItemLike>)SushiContent.Items.SEAWEED);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.AVOCADO_SAPLING);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.RICE_COOKER);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.SEAWEED_BLOCK);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.CUTTING_BOARD);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.AVOCADO_LOG);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.ROLLER);
            this.dropSelf((Supplier<? extends Block>)SushiContent.Blocks.FERMENTATION_BARREL);
            this.dropLeaves((Supplier<Block>)SushiContent.Blocks.AVOCADO_LEAVES, (Supplier<Block>)SushiContent.Blocks.AVOCADO_SAPLING);
            this.dropLeavesSpecial((Supplier<? extends Block>)SushiContent.Blocks.AVOCADO_LEAVES_LOG, (Supplier<? extends Block>)SushiContent.Blocks.AVOCADO_LOG);
            CopyNbtFunction.Builder nbtBuilder = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_);
            nbtBuilder.m_80279_("input", "BlockEntityTag.input");
            this.droppingSelfWithNbt((Supplier<? extends Block>)SushiContent.Blocks.COOLER_BOX, nbtBuilder);
        }

        private void crop(Supplier<CustomCropBlock> blockSupplier, Supplier<? extends Item> extra) {
            LootItemBlockStatePropertyCondition.Builder condition = LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)blockSupplier.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)blockSupplier.get().m_7959_(), blockSupplier.get().m_7419_()));
            this.m_124165_((Block)blockSupplier.get(), SushiBlockLootTables.m_124142_((Block)((Block)blockSupplier.get()), (Item)extra.get(), (Item)blockSupplier.get().m_6404_().m_5456_(), (LootItemCondition.Builder)condition));
            this.knownBlocks.add((Block)blockSupplier.get());
        }

        private void dropSelf(Supplier<? extends Block> blockSupplier) {
            this.m_124288_(blockSupplier.get());
            this.knownBlocks.add(blockSupplier.get());
        }

        private void dropOther(Supplier<Block> blockSupplier, Supplier<? extends ItemLike> other) {
            this.m_124147_(blockSupplier.get(), other.get());
            this.knownBlocks.add(blockSupplier.get());
        }

        private void dropLeaves(Supplier<Block> blockSupplier, Supplier<Block> sapling) {
            this.m_124175_(blockSupplier.get(), leaves -> SushiBlockLootTables.m_124157_((Block)leaves, (Block)((Block)sapling.get()), (float[])new float[]{0.15f, 0.2f, 0.3f, 0.4f}));
            this.knownBlocks.add(blockSupplier.get());
        }

        private void dropLeavesSpecial(Supplier<? extends Block> blockSupplier, Supplier<? extends Block> extra) {
            this.m_124175_(blockSupplier.get(), block -> SushiBlockLootTables.m_124283_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)SushiBlockLootTables.m_124134_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)extra.get()))))));
            this.knownBlocks.add(blockSupplier.get());
        }

        public void droppingSelfWithNbt(Supplier<? extends Block> itemProvider, CopyNbtFunction.Builder nbtBuilder) {
            this.m_124165_(itemProvider.get(), LootTable.m_79147_().m_79161_((LootPool.Builder)SushiBlockLootTables.m_124134_((ItemLike)((ItemLike)itemProvider.get()), (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)itemProvider.get())).m_5577_((LootItemFunction.Builder)nbtBuilder)))));
            this.knownBlocks.add(itemProvider.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }
    }
}

