/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.module;

import com.hrznstudio.titanium.block.BasicBlock;
import com.hrznstudio.titanium.block.BasicTileBlock;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class DeferredRegistryHelper {
    private final String modId;
    private HashMap<Class<? extends IForgeRegistryEntry>, DeferredRegister<? extends IForgeRegistryEntry>> registries;

    public DeferredRegistryHelper(String modId) {
        this.modId = modId;
        this.registries = new HashMap();
    }

    public <T extends IForgeRegistryEntry> DeferredRegister<? super T> addRegistry(Class<T> cl) {
        DeferredRegister deferredRegister = DeferredRegister.create(cl, (String)this.modId);
        deferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus());
        return deferredRegister;
    }

    private <T extends IForgeRegistryEntry<? super T>> RegistryObject<T> register(Class<T> cl, String name, Supplier<T> object) {
        DeferredRegister deferredRegister = this.registries.computeIfAbsent(cl, this::addRegistry);
        return deferredRegister.register(name, object);
    }

    public <T extends IForgeRegistryEntry<? super T>> RegistryObject<T> registerGeneric(Class<T> cl, String name, Supplier<T> object) {
        return this.register(cl, name, object);
    }

    public RegistryObject<BlockEntityType<?>> registerBlockEntityType(String name, Supplier<?> object) {
        DeferredRegister deferredRegister = this.registries.computeIfAbsent(BlockEntityType.class, this::addRegistry);
        return deferredRegister.register(name, object);
    }

    public RegistryObject<EntityType<?>> registerEntityType(String name, Supplier<?> object) {
        DeferredRegister deferredRegister = this.registries.computeIfAbsent(EntityType.class, this::addRegistry);
        return deferredRegister.register(name, object);
    }

    public RegistryObject<Block> registerBlockWithItem(String name, Supplier<? extends BasicBlock> blockSupplier) {
        RegistryObject<Block> blockRegistryObject = this.registerGeneric(Block.class, name, blockSupplier::get);
        this.registerGeneric(Item.class, name, () -> new BlockItem((Block)blockRegistryObject.get(), new Item.Properties().m_41491_(((BasicBlock)blockRegistryObject.get()).getItemGroup())));
        return blockRegistryObject;
    }

    public RegistryObject<Block> registerBlockWithItem(String name, Supplier<? extends Block> blockSupplier, Supplier<Item> itemSupplier) {
        DeferredRegister blockDeferredRegister = this.registries.computeIfAbsent(Block.class, this::addRegistry);
        DeferredRegister itemDeferredRegister = this.registries.computeIfAbsent(Item.class, this::addRegistry);
        itemDeferredRegister.register(name, itemSupplier);
        return blockDeferredRegister.register(name, blockSupplier);
    }

    public Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> registerBlockWithTile(String name, Supplier<BasicTileBlock> blockSupplier) {
        RegistryObject<Block> blockRegistryObject = this.registerBlockWithItem(name, blockSupplier);
        return Pair.of(blockRegistryObject, this.registerBlockEntityType(name, () -> BlockEntityType.Builder.m_155273_(((BasicTileBlock)blockRegistryObject.get()).getTileEntityFactory(), (Block[])new Block[]{(Block)blockRegistryObject.get()}).m_58966_(null)));
    }
}

