/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.container;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.assets.types.IBackgroundAsset;
import com.hrznstudio.titanium.client.screen.IScreenAddonConsumer;
import com.hrznstudio.titanium.client.screen.addon.AssetScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.WidgetScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.lwjgl.glfw.GLFW;

public class BasicContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IScreenAddonConsumer {
    private final T container;
    private final Component title;
    private IAssetProvider assetProvider;
    private int xCenter;
    private int yCenter;
    private List<IScreenAddon> addons;
    private int dragX;
    private int dragY;
    private boolean isMouseDragging;

    public BasicContainerScreen(T container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.container = container;
        this.title = title;
        this.assetProvider = IAssetProvider.DEFAULT_PROVIDER;
        IBackgroundAsset background = IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND);
        this.f_97726_ = background.getArea().width;
        this.f_97727_ = background.getArea().height;
        this.isMouseDragging = false;
        this.addons = new ArrayList<IScreenAddon>();
    }

    public BasicContainerScreen(T container, Inventory inventory, Component title, IAssetProvider provider) {
        super(container, inventory, title);
        this.container = container;
        this.title = title;
        this.assetProvider = provider;
        IBackgroundAsset background = IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND);
        this.f_97726_ = background.getArea().width;
        this.f_97727_ = background.getArea().height;
        this.addons = new ArrayList<IScreenAddon>();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.getAddons().forEach(screenAddon -> screenAddon.init(this.f_97735_, this.f_97736_));
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(stack);
        this.xCenter = (this.f_96543_ - this.f_97726_) / 2;
        this.yCenter = (this.f_96544_ - this.f_97727_) / 2;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND).getResourceLocation());
        this.m_93228_(stack, this.xCenter, this.yCenter, 0, 0, this.f_97726_, this.f_97727_);
        Minecraft.m_91087_().f_91062_.m_92883_(stack, ChatFormatting.DARK_GRAY + this.title.getString(), (float)(this.xCenter + this.f_97726_ / 2 - Minecraft.m_91087_().f_91062_.m_92895_(this.title.getString()) / 2), (float)(this.yCenter + 6), 0xFFFFFF);
        this.addons.stream().filter(IScreenAddon::isBackground).forEach(iGuiAddon -> iGuiAddon.drawBackgroundLayer(stack, (Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY, partialTicks));
        this.addons.stream().filter(iScreenAddon -> !iScreenAddon.isBackground()).forEach(iGuiAddon -> iGuiAddon.drawBackgroundLayer(stack, (Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY, partialTicks));
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        this.addons.forEach(iGuiAddon -> {
            if (iGuiAddon instanceof AssetScreenAddon) {
                AssetScreenAddon assetGuiAddon = (AssetScreenAddon)iGuiAddon;
                if (!assetGuiAddon.isBackground()) {
                    iGuiAddon.drawForegroundLayer(stack, (Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY, this.f_96541_.m_91297_());
                }
            } else {
                iGuiAddon.drawForegroundLayer(stack, (Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY, this.f_96541_.m_91297_());
            }
        });
        this.m_7025_(stack, mouseX - this.xCenter, mouseY - this.yCenter);
        for (IScreenAddon iScreenAddon : this.addons) {
            if (!iScreenAddon.m_5953_(mouseX - this.xCenter, mouseY - this.yCenter) || iScreenAddon.getTooltipLines().isEmpty()) continue;
            this.m_169388_(stack, iScreenAddon.getTooltipLines(), Optional.empty(), mouseX - this.xCenter, mouseY - this.yCenter);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.m_6702_() != null) {
            for (GuiEventListener listener : this.m_6702_()) {
                if (!(listener instanceof WidgetScreenAddon)) continue;
                WidgetScreenAddon addon = (WidgetScreenAddon)listener;
                AbstractWidget widget = addon.getWidget();
                if (widget.m_7933_(keyCode, scanCode, modifiers)) {
                    return true;
                }
                if (!widget.m_93696_() || scanCode != 18) continue;
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void checkForMouseDrag(int mouseX, int mouseY) {
        int pressedButton = GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)0);
        if (pressedButton == 1) {
            if (!this.isMouseDragging) {
                this.isMouseDragging = true;
            } else {
                for (IScreenAddon iScreenAddon : this.addons) {
                    if (!iScreenAddon.m_5953_(mouseX - this.xCenter, mouseY - this.yCenter)) continue;
                    iScreenAddon.m_7979_(mouseX - this.xCenter, mouseY - this.yCenter, pressedButton, this.dragX, this.dragY);
                }
            }
            this.dragX = mouseX;
            this.dragY = mouseY;
        } else {
            this.isMouseDragging = false;
        }
    }

    public int getX() {
        return this.xCenter;
    }

    public int getY() {
        return this.yCenter;
    }

    @Nonnull
    public T m_6262_() {
        return this.container;
    }

    public List<IScreenAddon> getAddons() {
        return this.addons;
    }

    public List<? extends GuiEventListener> m_6702_() {
        if (super.m_6702_() != null) {
            List collect = super.m_6702_().stream().map(guiEventListener -> guiEventListener).collect(Collectors.toList());
            collect.addAll(this.getAddons());
            return collect;
        }
        return new ArrayList();
    }

    public void setAddons(List<IScreenAddon> addons) {
        this.addons = addons;
    }

    public IAssetProvider getAssetProvider() {
        return this.assetProvider;
    }

    public void setAssetProvider(IAssetProvider assetProvider) {
        this.assetProvider = assetProvider;
    }
}

