/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.tile.machinery;

import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.buuz135.sushigocrafting.recipe.CuttingBoardRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.RecipeUtil;
import com.hrznstudio.titanium.util.TagUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;

public class CuttingBoardTile
extends ActiveTile<CuttingBoardTile> {
    public static TagKey<Item> KNIFE = TagUtil.getItemTag((ResourceLocation)new ResourceLocation("forge", "tools/knife"));
    @Save
    private final InventoryComponent<CuttingBoardTile> input = new InventoryComponent("input", 0, 0, 1).setInputFilter((stack, integer) -> this.accepts((ItemStack)stack));
    @Save
    private int click;

    public CuttingBoardTile(BlockPos pos, BlockState state) {
        super((BasicTileBlock)SushiContent.Blocks.CUTTING_BOARD.get(), (BlockEntityType)SushiContent.TileEntities.CUTTING_BOARD.get(), pos, state);
        this.addInventory(this.input);
        this.click = 0;
    }

    public InteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_()) {
            if (!this.input.getStackInSlot(0).m_41619_() && TagUtil.hasTag((IForgeRegistry)ForgeRegistries.ITEMS, (ForgeRegistryEntry)stack.m_41720_(), KNIFE)) {
                ++this.click;
                if (this.click > 5) {
                    for (CuttingBoardRecipe recipe : RecipeUtil.getRecipes((Level)this.f_58857_, (RecipeType)CuttingBoardRecipe.SERIALIZER.getRecipeType())) {
                        if (!recipe.getInput().test(this.input.getStackInSlot(0))) continue;
                        Item item = FoodAPI.get().getIngredientFromName(recipe.getIngredient()).getItem();
                        if (item instanceof AmountItem) {
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((AmountItem)item).random(player, this.f_58857_));
                        } else {
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)item));
                        }
                        this.input.getStackInSlot(0).m_41774_(1);
                    }
                    this.click = 0;
                }
                this.syncObject(this.click);
                return InteractionResult.SUCCESS;
            }
            if (this.input.getStackInSlot(0).m_41619_() && this.accepts(stack)) {
                this.input.insertItem(0, stack.m_41777_(), false);
                stack.m_41764_(0);
                return InteractionResult.SUCCESS;
            }
        } else if (player.m_6144_()) {
            ItemStack inserted = this.input.getStackInSlot(0).m_41777_();
            this.input.setStackInSlot(0, ItemStack.f_41583_);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inserted);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nonnull
    public CuttingBoardTile getSelf() {
        return this;
    }

    public InventoryComponent<CuttingBoardTile> getInput() {
        return this.input;
    }

    public int getClick() {
        return this.click;
    }

    private boolean accepts(ItemStack input) {
        return RecipeUtil.getRecipes((Level)this.f_58857_, (RecipeType)CuttingBoardRecipe.SERIALIZER.getRecipeType()).stream().anyMatch(cuttingBoardRecipe -> cuttingBoardRecipe.getInput().test(input));
    }
}

