/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.client.gui;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IIngredientConsumer;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.cap.SushiWeightDiscoveryCapability;
import com.buuz135.sushigocrafting.client.gui.provider.SushiAssetTypes;
import com.buuz135.sushigocrafting.tile.machinery.RollerTile;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import org.apache.commons.lang3.tuple.Pair;

public abstract class RollerWeightSelectorButtonComponent
extends BasicScreenAddon {
    private final InventoryComponent<RollerTile> inventoryComponent;
    private final int slot;

    public RollerWeightSelectorButtonComponent(InventoryComponent inventoryComponent, int slot) {
        super(0, 0);
        this.inventoryComponent = inventoryComponent;
        this.slot = slot;
    }

    public static void drawBackground(PoseStack matrixStack, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int posX, int posY) {
        IAsset asset = iAssetProvider.getAsset(SushiAssetTypes.ROLLER_WEIGHT_PICKER_BG);
        if (asset != null) {
            AssetUtil.drawAsset((PoseStack)matrixStack, (Screen)screen, (IAsset)asset, (int)(guiX + posX), (int)(guiY + posY));
        }
    }

    public static void drawForeground(PoseStack matrixStack, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int posX, int posY, int weight, int ySize, String type, int slot) {
        IAsset asset = iAssetProvider.getAsset(SushiAssetTypes.ROLLER_WEIGHT_PICKER_POINTER);
        if (asset != null && weight != Integer.MIN_VALUE) {
            AssetUtil.drawAsset((PoseStack)matrixStack, (Screen)screen, (IAsset)asset, (int)posX, (int)(posY + (4 - weight) * (ySize / 4) - 1));
        }
        Minecraft.m_91087_().f_91074_.getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(iSushiWeightDiscovery -> {
            if (iSushiWeightDiscovery.hasDiscovery(type + "-" + slot)) {
                int pos = posY + (4 - iSushiWeightDiscovery.getDiscovery(type + "-" + slot)) * (ySize / 4) - 1;
                AssetUtil.drawAsset((PoseStack)matrixStack, (Screen)screen, (IAsset)iAssetProvider.getAsset(SushiAssetTypes.ROLLER_WEIGHT_PERFECT_POINTER), (int)(posX + 1), (int)(pos + 1));
            }
        });
    }

    public void drawBackgroundLayer(PoseStack matrixStack, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int mouseX, int mouseY, float v) {
        RollerWeightSelectorButtonComponent.drawBackground(matrixStack, screen, iAssetProvider, guiX, guiY, this.getPosX(), this.getPosY());
    }

    public void drawForegroundLayer(PoseStack matrixStack, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int mouseX, int mouseY, float v) {
        RollerWeightSelectorButtonComponent.drawForeground(matrixStack, screen, iAssetProvider, guiX, guiY, this.getPosX(), this.getPosY(), this.getWeight(), this.getYSize(), this.getType(), this.slot);
    }

    public int getPosX() {
        return (Integer)((Pair)this.inventoryComponent.getSlotPosition().apply(this.slot)).getKey() + 17;
    }

    public int getPosY() {
        return (Integer)((Pair)this.inventoryComponent.getSlotPosition().apply(this.slot)).getValue() - 1;
    }

    public int getXSize() {
        return 4;
    }

    public int getYSize() {
        return 18;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AbstractContainerScreen && ((AbstractContainerScreen)screen).m_6262_() instanceof ILocatable) {
            if (!this.m_5953_(mouseX - (double)((AbstractContainerScreen)screen).getGuiLeft(), mouseY - (double)((AbstractContainerScreen)screen).getGuiTop())) {
                return false;
            }
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(SoundEvents.f_12633_, SoundSource.PLAYERS, 0.5f, 1.0f, Minecraft.m_91087_().f_91074_.m_142538_()));
            ILocatable locatable = (ILocatable)((AbstractContainerScreen)screen).m_6262_();
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("WeightSlot", this.slot);
            nbt.m_128405_("Button", button);
            Titanium.NETWORK.get().sendToServer((Object)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), 100, nbt));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)this.getPosX() && mouseX <= (double)(this.getPosX() + this.getXSize()) && mouseY >= (double)this.getPosY() && mouseY <= (double)(this.getPosY() + this.getYSize());
    }

    public List<Component> getTooltipLines() {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (this.inventoryComponent.getStackInSlot(this.slot).m_41619_()) {
            lines.add((Component)new TextComponent(NumberFormat.getInstance(Locale.getDefault()).format((double)(this.getWeight() + 1) / 5.0 * 100.0) + ChatFormatting.DARK_AQUA + "%" + ChatFormatting.GOLD + " Weight"));
        } else {
            IFoodIngredient ingredient = FoodAPI.get().getIngredientFromItem(this.inventoryComponent.getStackInSlot(this.slot).m_41720_());
            if (!ingredient.isEmpty()) {
                String unit = ingredient.getIngredientConsumer() == IIngredientConsumer.STACK ? "u" : "gr";
                double amount = ingredient.getIngredientConsumer() == IIngredientConsumer.STACK ? (double)(ingredient.getDefaultAmount() * (this.getWeight() + 1)) : (double)(ingredient.getDefaultAmount() * (this.getWeight() + 1)) / 5.0;
                lines.add((Component)new TextComponent(ChatFormatting.GOLD + "Consumes " + ChatFormatting.WHITE + NumberFormat.getInstance(Locale.getDefault()).format(amount) + ChatFormatting.YELLOW + unit));
            }
        }
        lines.add((Component)new TextComponent(ChatFormatting.DARK_GRAY + "*Left Click to Increase*"));
        lines.add((Component)new TextComponent(ChatFormatting.DARK_GRAY + "*Right Click to Decrease*"));
        return lines;
    }

    public abstract int getWeight();

    public abstract String getType();
}

