/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.tile.machinery;

import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.util.TagUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class RiceCookerTile
extends ActiveTile<RiceCookerTile> {
    public static TagKey<Item> RICE = TagUtil.getItemTag((ResourceLocation)new ResourceLocation("forge", "crops/rice"));
    @Save
    private final InventoryComponent<RiceCookerTile> input = new InventoryComponent("input", 20, 38, 4).setRange(2, 2).setSlotToColorRender(0, DyeColor.BLUE).setSlotToColorRender(1, DyeColor.BLUE).setSlotToColorRender(2, DyeColor.BLUE).setSlotToColorRender(3, DyeColor.BLUE).setSlotLimit(1).setInputFilter((stack, integer) -> stack.m_204117_(RICE)).setOutputFilter((stack, integer) -> false);
    @Save
    private ProgressBarComponent<RiceCookerTile> bar;
    @Save
    private InventoryComponent<RiceCookerTile> output;
    @Save
    private FluidTankComponent<RiceCookerTile> water;
    @Save
    private final InventoryComponent<RiceCookerTile> fuel;
    @Save
    private double burnTime = 0.0;

    public RiceCookerTile(BlockPos pos, BlockState state) {
        super((BasicTileBlock)SushiContent.Blocks.RICE_COOKER.get(), (BlockEntityType)SushiContent.TileEntities.RICE_COOKER.get(), pos, state);
        this.addInventory(this.input);
        this.bar = new ProgressBarComponent(99, 48, 100).setCanIncrease(RiceCookerTile::canStart).setCanReset(RiceCookerTile::canStart).setOnTickWork(() -> this.syncObject(this.bar)).setBarDirection(ProgressBarComponent.BarDirection.ARROW_RIGHT).setOnFinishWork(() -> {
            ItemStack result = ((AmountItem)((Object)((Object)SushiContent.Items.COOKED_RICE.get()))).withAmount(this.getSlotsFilled() * 50);
            if (!this.output.getStackInSlot(0).m_41619_()) {
                ItemStack original = this.output.getStackInSlot(0);
                result = ((AmountItem)((Object)((Object)SushiContent.Items.COOKED_RICE.get()))).withAmount(Math.min(((AmountItem)original.m_41720_()).getMaxCombineAmount(), ((AmountItem)original.m_41720_()).getCurrentAmount(original) + ((AmountItem)result.m_41720_()).getCurrentAmount(result)));
            }
            this.output.setStackInSlot(0, result);
            for (int i = 0; i < this.input.getSlots(); ++i) {
                this.input.setStackInSlot(i, ItemStack.f_41583_);
            }
            this.water.drainForced(1000, IFluidHandler.FluidAction.EXECUTE);
            this.burnTime -= 1.0;
            this.syncObject(this.bar);
            this.m_6596_();
        });
        this.addProgressBar(this.bar);
        this.output = new InventoryComponent("output", 134, 48, 1).setSlotToColorRender(0, DyeColor.ORANGE).setSlotLimit(1).setInputFilter((stack, integer) -> false).setOutputFilter((stack, integer) -> true);
        this.addInventory(this.output);
        this.water = (FluidTankComponent)new FluidTankComponent("water", 8000, 68, 27).setTankAction(FluidTankComponent.Action.FILL).setTankType(FluidTankComponent.Type.SMALL).setValidator(fluidStack -> fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76193_));
        this.addTank(this.water);
        this.fuel = new InventoryComponent("fuel", 69, 67, 1).setSlotToColorRender(0, DyeColor.RED).setSlotLimit(64).setInputFilter((stack, integer) -> ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0);
        this.addInventory(this.fuel);
    }

    @Nonnull
    public RiceCookerTile getSelf() {
        return this;
    }

    public InteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        InteractionResult type = super.onActivated(player, hand, facing, hitX, hitY, hitZ);
        if (!type.m_19080_()) {
            this.openGui(player);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public boolean canStart() {
        if (this.burnTime < 1.0 && !this.fuel.getStackInSlot(0).m_41619_()) {
            this.burnTime += (double)ForgeHooks.getBurnTime((ItemStack)this.fuel.getStackInSlot(0), (RecipeType)RecipeType.f_44108_) / 200.0;
            this.fuel.getStackInSlot(0).m_41774_(1);
            this.m_6596_();
        }
        return this.burnTime > 0.0 && this.getSlotsFilled() > 0 && (this.output.getStackInSlot(0).m_41619_() || ((AmountItem)this.output.getStackInSlot(0).m_41720_()).getCurrentAmount(this.output.getStackInSlot(0)) < ((AmountItem)this.output.getStackInSlot(0).m_41720_()).getMaxCombineAmount()) && this.water.getFluidAmount() >= 1000;
    }

    private int getSlotsFilled() {
        int amount = 0;
        for (int i = 0; i < this.input.getSlots(); ++i) {
            if (this.input.getStackInSlot(i).m_41619_()) continue;
            ++amount;
        }
        return amount;
    }

    public ProgressBarComponent<RiceCookerTile> getBar() {
        return this.bar;
    }
}

