/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium._impl.creative.tile;

import com.hrznstudio.titanium._impl.creative.CreativeFEGeneratorBlock;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.PoweredTile;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.registries.RegistryObject;

public class CreativeFEGeneratorTile
extends PoweredTile<CreativeFEGeneratorTile> {
    public CreativeFEGeneratorTile(BlockPos pos, BlockState state) {
        super((BasicTileBlock)((RegistryObject)CreativeFEGeneratorBlock.INSTANCE.getLeft()).get(), (BlockEntityType)((RegistryObject)CreativeFEGeneratorBlock.INSTANCE.getRight()).get(), pos, state);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, CreativeFEGeneratorTile blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        this.getEnergyStorage().receiveEnergy(Integer.MAX_VALUE, false);
        for (Direction direction : Direction.values()) {
            BlockEntity tile = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
            if (tile == null) continue;
            tile.getCapability(CapabilityEnergy.ENERGY, direction.m_122424_()).ifPresent(iEnergyStorage -> iEnergyStorage.receiveEnergy(Integer.MAX_VALUE, false));
        }
        this.markForUpdate();
    }

    @Override
    @Nonnull
    public CreativeFEGeneratorTile getSelf() {
        return this;
    }

    @Override
    @ParametersAreNonnullByDefault
    public InteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(player, hand, facing, hitX, hitY, hitZ) == InteractionResult.PASS) {
            this.openGui(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nonnull
    public EnergyStorageComponent<CreativeFEGeneratorTile> createEnergyStorage() {
        return new EnergyStorageComponent<CreativeFEGeneratorTile>(Integer.MAX_VALUE, 0, 0);
    }
}

