/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ProgressBarScreenAddon<T extends IComponentHarness>
extends BasicScreenAddon {
    private ProgressBarComponent<T> progressBar;
    private IAssetProvider provider;

    public ProgressBarScreenAddon(int posX, int posY, ProgressBarComponent<T> progressBarComponent) {
        super(posX, posY);
        this.progressBar = progressBarComponent;
    }

    @Override
    public int getXSize() {
        return this.provider != null ? this.progressBar.getBarDirection().getXSize(this.provider) : 0;
    }

    @Override
    public int getYSize() {
        return this.provider != null ? this.progressBar.getBarDirection().getYSize(this.provider) : 0;
    }

    @Override
    public void drawBackgroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.provider = provider;
        this.progressBar.getBarDirection().render(stack, screen, guiX, guiY, provider, this);
    }

    @Override
    public void drawForegroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }

    public ProgressBarComponent<T> getProgressBar() {
        return this.progressBar;
    }

    @Override
    public List<Component> getTooltipLines() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + Component.m_237115_((String)"tooltip.titanium.progressbar.progress").getString() + ChatFormatting.WHITE + new DecimalFormat().format(this.progressBar.getProgress()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(this.progressBar.getMaxProgress()))));
        int progress = this.progressBar.getMaxProgress() - this.progressBar.getProgress();
        if (!this.progressBar.getIncreaseType()) {
            progress = this.progressBar.getMaxProgress() - progress;
        }
        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "ETA: " + ChatFormatting.WHITE + new DecimalFormat().format(Math.ceil((double)(progress * this.progressBar.getTickingTime()) / 20.0 / (double)this.progressBar.getProgressIncrease())) + ChatFormatting.DARK_AQUA + "s")));
        return tooltip;
    }
}

