/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.command;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.reward.RewardManager;
import com.hrznstudio.titanium.reward.RewardSyncMessage;
import com.hrznstudio.titanium.reward.storage.RewardWorldStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;

public class RewardCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"titanium-rewards").then(Commands.m_82129_((String)"action", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"enable", "disable"}, (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"reward", (ArgumentType)new ResourceLocationArgument()).suggests((context, builder) -> SharedSuggestionProvider.m_82981_(RewardCommand.getAvailableResourceLocations((CommandContext<CommandSourceStack>)context).stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"option", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])RewardManager.get().getReward((ResourceLocation)context.getArgument("reward", ResourceLocation.class)).getOptions(), (SuggestionsBuilder)builder)).executes(context -> {
            RewardCommand.execute((CommandContext<CommandSourceStack>)context);
            return 1;
        })))));
    }

    private static void execute(CommandContext<CommandSourceStack> context) {
        boolean changed = false;
        changed = ((String)context.getArgument("action", String.class)).equalsIgnoreCase("enable") ? RewardCommand.addReward(context) : RewardCommand.removeReward(context);
        if (changed) {
            ((CommandSourceStack)context.getSource()).m_81377_().execute(() -> {
                CompoundTag nbt = RewardWorldStorage.get(((CommandSourceStack)context.getSource()).m_81377_().m_129880_(Level.f_46428_)).serializeSimple();
                ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_().forEach(serverPlayerEntity -> Titanium.NETWORK.get().sendTo((Object)new RewardSyncMessage(nbt), serverPlayerEntity.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
            });
        }
    }

    private static boolean removeReward(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        RewardWorldStorage rewardWorldStorage = RewardWorldStorage.get(source.m_81372_());
        try {
            rewardWorldStorage.remove(source.m_81375_().m_20148_(), (ResourceLocation)context.getArgument("reward", ResourceLocation.class));
            rewardWorldStorage.m_77762_();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"titanium.rewards.remove_success"), true);
            return true;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean addReward(CommandContext<CommandSourceStack> context) {
        try {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ResourceLocation resourceLocation = (ResourceLocation)context.getArgument("reward", ResourceLocation.class);
            if (RewardManager.get().getReward(resourceLocation) == null || !RewardManager.get().getReward(resourceLocation).isPlayerValid(source.m_81375_().m_20148_())) {
                return false;
            }
            RewardWorldStorage rewardWorldStorage = RewardWorldStorage.get(source.m_81372_());
            String option = (String)context.getArgument("option", String.class);
            if (!Arrays.asList(RewardManager.get().getReward(resourceLocation).getOptions()).contains(option)) {
                return false;
            }
            rewardWorldStorage.add(source.m_81375_().m_20148_(), (ResourceLocation)context.getArgument("reward", ResourceLocation.class), option);
            rewardWorldStorage.m_77762_();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"titanium.rewards.enabled_success"), true);
            return true;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static List<ResourceLocation> getAvailableResourceLocations(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        RewardWorldStorage rewardWorldStorage = RewardWorldStorage.get(source.m_81372_());
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>(rewardWorldStorage.getFreeRewards());
        try {
            resourceLocations.addAll(RewardManager.get().collectRewardsResourceLocations(((CommandSourceStack)context.getSource()).m_81375_().m_20148_()));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return resourceLocations;
    }
}

