/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.flower;

import com.feywild.feywild.block.flower.GiantFlowerSeedItem;
import com.feywild.feywild.config.ClientConfig;
import com.google.common.collect.ImmutableMap;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public abstract class GiantFlowerBlock
extends Block
implements Registerable {
    public static final VoxelShape STEM_SHAPE = GiantFlowerBlock.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final VoxelShape FLOWER_SHAPE = GiantFlowerBlock.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final IntegerProperty PART = IntegerProperty.func_177719_a((String)"part", (int)0, (int)3);
    public final int height;
    private final GiantFlowerSeedItem item;

    public GiantFlowerBlock(ModX mod, int height) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_226896_b_().harvestTool(ToolType.AXE).func_200947_a(SoundType.field_222468_o).func_200948_a(1.0f, 1.0f).func_235838_a_(value -> 8));
        this.height = height;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)PART, (Comparable)Integer.valueOf(3)));
        this.item = new GiantFlowerSeedItem(mod, this);
    }

    public Map<String, Object> getNamedAdditionalRegisters() {
        return ImmutableMap.of((Object)"seed", (Object)((Object)this.item));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(ResourceLocation id, Consumer<Runnable> defer) {
        defer.accept(() -> RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228643_e_()));
    }

    protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PART});
    }

    public GiantFlowerSeedItem getSeed() {
        return this.item;
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return (Integer)state.func_177229_b((Property)PART) == 3 ? FLOWER_SHAPE : STEM_SHAPE;
    }

    @Nonnull
    public VoxelShape func_230322_a_(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    @Nonnull
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return (Integer)state.func_177229_b((Property)PART) == 1 || (Integer)state.func_177229_b((Property)PART) == 3 ? BlockRenderType.MODEL : BlockRenderType.INVISIBLE;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)this.getSeed());
    }

    public void func_196243_a(@Nonnull BlockState oldState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean moving) {
        if (oldState.func_177230_c() != newState.func_177230_c()) {
            this.removeOthers(world, oldState, pos);
        }
        super.func_196243_a(oldState, world, pos, newState, moving);
    }

    @Nonnull
    public PushReaction func_149656_h(@Nonnull BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean func_149653_t(@Nonnull BlockState state) {
        return (Integer)state.func_177229_b((Property)PART) == 3;
    }

    public void func_225542_b_(@Nonnull BlockState state, @Nonnull ServerWorld world, @Nonnull BlockPos pos, @Nonnull Random random) {
        super.func_225542_b_(state, world, pos, random);
        if ((Integer)state.func_177229_b((Property)PART) == 3) {
            this.tickFlower(state, world, pos, random);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random random) {
        super.func_180655_c(state, world, pos, random);
        if ((Integer)state.func_177229_b((Property)PART) == 3 && ClientConfig.flower_particles) {
            this.animateFlower(state, world, pos, random);
        }
    }

    protected abstract void tickFlower(BlockState var1, ServerWorld var2, BlockPos var3, Random var4);

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void animateFlower(BlockState var1, World var2, BlockPos var3, Random var4);

    public abstract BlockState flowerState(IWorld var1, BlockPos var2, Random var3);

    protected void removeOthers(World world, BlockState state, BlockPos pos) {
        BlockPos target;
        int i;
        int blocksBelow = (Integer)state.func_177229_b((Property)PART) - (4 - this.height);
        int blocksAbove = 3 - (Integer)state.func_177229_b((Property)PART);
        for (i = 1; i <= blocksBelow; ++i) {
            target = pos.func_177982_a(0, -i, 0);
            if (world.func_180495_p(target).func_177230_c() != this) continue;
            world.func_180501_a(target, Blocks.field_150350_a.func_176223_P(), 2);
        }
        for (i = 1; i <= blocksAbove; ++i) {
            target = pos.func_177982_a(0, i, 0);
            if (world.func_180495_p(target).func_177230_c() != this) continue;
            world.func_180501_a(target, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }
}

