/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.render;

import com.feywild.feywild.block.entity.FeyAltar;
import com.feywild.feywild.block.model.FeyAltarModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.noeppi_noeppi.libx.render.ClientTickHandler;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.vector.Vector3f;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoBlockRenderer;

public class FeyAltarRenderer
extends GeoBlockRenderer<FeyAltar> {
    public FeyAltarRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher, (AnimatedGeoModel)new FeyAltarModel());
    }

    public void render(FeyAltar tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light) {
        super.render((TileEntity)tile, partialTicks, matrixStack, buffer, light);
        double progressScaled = (double)tile.getProgress() / 40.0;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int slot = 0; slot < tile.getInventory().getSlots(); ++slot) {
            ItemStack stack = tile.getInventory().getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            stacks.add(stack);
        }
        if (!stacks.isEmpty()) {
            double anglePerStack = Math.PI * 2 / (double)stacks.size();
            for (int idx = 0; idx < stacks.size(); ++idx) {
                double shiftX = Math.cos(((double)tile.func_145831_w().func_82737_E() + (double)partialTicks) / 8.0 + (double)idx * anglePerStack) * (1.0 - progressScaled);
                double shiftZ = Math.sin(((double)tile.func_145831_w().func_82737_E() + (double)partialTicks) / 8.0 + (double)idx * anglePerStack) * (1.0 - progressScaled);
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.5 + shiftX, 1.0 + progressScaled, 0.5 + shiftZ);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(((float)ClientTickHandler.ticksInGame + partialTicks) / 20.0f));
                matrixStack.func_227862_a_(0.85f, 0.85f, 0.85f);
                Minecraft.func_71410_x().func_175599_af().func_229110_a_((ItemStack)stacks.get(idx), ItemCameraTransforms.TransformType.GROUND, light, OverlayTexture.field_229196_a_, matrixStack, buffer);
                matrixStack.func_227865_b_();
            }
        }
    }
}

