/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.trees;

import com.feywild.feywild.block.ModBlocks;
import com.feywild.feywild.block.trees.BaseTree;
import com.feywild.feywild.block.trees.DecoratingGiantTrunkPlacer;
import com.feywild.feywild.block.trees.FeyLeavesBlock;
import com.feywild.feywild.particles.ModParticles;
import com.google.common.collect.ImmutableList;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.treedecorator.AlterGroundTreeDecorator;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.server.ServerWorld;

public class AutumnTree
extends BaseTree {
    public AutumnTree(ModX mod) {
        super(mod, () -> new FeyLeavesBlock(mod, 10, ModParticles.leafParticle));
    }

    @Override
    protected BaseTreeFeatureConfig.Builder getFeatureBuilder(@Nonnull Random random, boolean largeHive) {
        return super.getFeatureBuilder(random, largeHive).func_236703_a_((List)ImmutableList.of((Object)new AlterGroundTreeDecorator((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196661_l.func_176223_P()))));
    }

    @Override
    protected AbstractTrunkPlacer getGiantTrunkPlacer() {
        return new TrunkPlacer(this.getBaseHeight(), this.getFirstRandomHeight(), this.getSecondRandomHeight());
    }

    @Override
    public void decorateSaplingGrowth(ServerWorld world, BlockPos pos, Random random) {
        if (random.nextDouble() < 0.2) {
            world.func_175656_a(pos, AutumnTree.getDecorationBlock(random));
        }
    }

    private static BlockState getDecorationBlock(Random random) {
        switch (random.nextInt(20)) {
            case 0: {
                return Blocks.field_150423_aK.func_176223_P();
            }
            case 1: {
                return Blocks.field_196625_cS.func_176223_P();
            }
            case 2: {
                return Blocks.field_150337_Q.func_176223_P();
            }
            case 3: {
                return Blocks.field_150338_P.func_176223_P();
            }
        }
        return Blocks.field_196554_aH.func_176223_P();
    }

    private static class TrunkPlacer
    extends DecoratingGiantTrunkPlacer {
        public TrunkPlacer(int p_i232058_1_, int p_i232058_2_, int p_i232058_3_) {
            super(p_i232058_1_, p_i232058_2_, p_i232058_3_);
        }

        @Override
        protected void decorateLog(BlockState state, ISeedReader world, BlockPos pos, Random random) {
            if (random.nextDouble() < 0.02) {
                if (world.func_175623_d(pos.func_177978_c())) {
                    world.func_180501_a(pos.func_177978_c(), (BlockState)ModBlocks.treeMushroom.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH), 19);
                }
                if (world.func_175623_d(pos.func_177974_f())) {
                    world.func_180501_a(pos.func_177974_f(), (BlockState)ModBlocks.treeMushroom.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.EAST), 19);
                }
                if (world.func_175623_d(pos.func_177968_d())) {
                    world.func_180501_a(pos.func_177968_d(), (BlockState)ModBlocks.treeMushroom.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH), 19);
                }
                if (world.func_175623_d(pos.func_177976_e())) {
                    world.func_180501_a(pos.func_177976_e(), (BlockState)ModBlocks.treeMushroom.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.WEST), 19);
                }
            }
        }
    }
}

