/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.data;

import com.feywild.feywild.block.ModTrees;
import com.feywild.feywild.item.ModItems;
import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.quest.Quest;
import com.feywild.feywild.quest.QuestDisplay;
import com.feywild.feywild.quest.QuestReward;
import com.feywild.feywild.quest.QuestTask;
import com.feywild.feywild.quest.reward.ItemReward;
import com.feywild.feywild.quest.task.CraftTask;
import com.feywild.feywild.quest.task.FeyGiftTask;
import com.feywild.feywild.quest.task.ItemTask;
import com.feywild.feywild.quest.task.KillTask;
import com.feywild.feywild.quest.task.SpecialTask;
import com.feywild.feywild.quest.util.FeyGift;
import com.feywild.feywild.quest.util.SpecialTaskAction;
import com.feywild.feywild.sound.ModSoundEvents;
import com.feywild.feywild.util.DatapackHelper;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.github.noeppi_noeppi.libx.crafting.IngredientStack;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.Tags;

public class QuestProvider
implements IDataProvider {
    private final ModX mod;
    private final DataGenerator generator;
    private final Map<Alignment, Set<Quest>> quests = new HashMap<Alignment, Set<Quest>>();

    public QuestProvider(ModX mod, DataGenerator generator) {
        this.mod = mod;
        this.generator = generator;
    }

    public void setup() {
        this.root(Alignment.SPRING).icon((IItemProvider)Items.field_151045_i).reputation(25).startSound(ModSoundEvents.summoningSpringPixie).build();
        this.quest(Alignment.SPRING, "levitate_sheep").parent("root").icon((IItemProvider)Blocks.field_196562_aR).task(QuestTask.of(SpecialTask.INSTANCE, SpecialTaskAction.LEVITATE_SHEEP, 3)).build();
        this.quest(Alignment.SPRING, "cake").parent("levitate_sheep").gift(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222070_lD}), 2).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((IItemProvider)Items.field_222112_pR, 6))).build();
        this.quest(Alignment.SPRING, "honey").parent("cake").gift(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.honeycomb}), 1).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((IItemProvider)ModItems.honeycomb, 1))).build();
        this.quest(Alignment.SPRING, "sapling").parent("honey").icon((IItemProvider)ModTrees.springTree.getSapling()).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((IItemProvider)ModTrees.springTree.getSapling(), 3))).build();
        this.root(Alignment.SUMMER).icon((IItemProvider)Items.field_151045_i).reputation(25).startSound(ModSoundEvents.summoningSummerPixie).build();
        this.quest(Alignment.SUMMER, "kill_golem").parent("root").icon((IItemProvider)Items.field_191525_da).task(QuestTask.of(KillTask.INSTANCE, EntityType.field_200757_aw)).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((IItemProvider)Items.field_151042_j, 7))).build();
        this.quest(Alignment.SUMMER, "bee_nest").reputation(20).parent("kill_golem").gift(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_226905_ma_})).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((IItemProvider)Items.field_226635_pU_))).build();
        this.quest(Alignment.SUMMER, "kill_pillager").parent("bee_nest").icon((IItemProvider)Items.field_151036_c).task(QuestTask.of(KillTask.INSTANCE, EntityType.field_220350_aJ, 5)).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((IItemProvider)Items.field_151043_k, 3))).build();
        this.quest(Alignment.SUMMER, "sapling").parent("kill_pillager").icon((IItemProvider)ModTrees.summerTree.getSapling()).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((IItemProvider)ModTrees.summerTree.getSapling(), 3))).build();
        this.root(Alignment.AUTUMN).icon((IItemProvider)Items.field_151045_i).reputation(25).startSound(ModSoundEvents.summoningAutumnPixie).build();
        this.quest(Alignment.AUTUMN, "food_potatoes").parent("root").complete(null).gift(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151174_bG}), 9).build();
        this.quest(Alignment.AUTUMN, "food_beetroots").parent("root").complete(null).gift(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185164_cV}), 9).build();
        this.quest(Alignment.AUTUMN, "food_carrots").parent("root").complete(null).gift(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151172_bF}), 9).build();
        this.quest(Alignment.AUTUMN, "food_complete").parent("food_potatoes", "food_beetroots", "food_carrots").icon((IItemProvider)Items.field_185165_cW).complete(null).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((IItemProvider)Items.field_185165_cW, 1))).build();
        this.quest(Alignment.AUTUMN, "pumpkin").parent("food_complete").task(QuestTask.of(ItemTask.INSTANCE, new IngredientStack(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196625_cS}), 2))).build();
        this.quest(Alignment.AUTUMN, "dyes").parent("pumpkin").icon((IItemProvider)Items.field_222078_li).task(QuestTask.of(CraftTask.INSTANCE, Ingredient.func_199805_a((ITag)Tags.Items.DYES), 9)).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((IItemProvider)ModTrees.autumnTree.getSapling(), 3))).build();
        this.root(Alignment.WINTER).icon((IItemProvider)Items.field_151045_i).reputation(25).startSound(ModSoundEvents.summoningWinterPixie).build();
        this.quest(Alignment.WINTER, "snowballs").parent("root").gift(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151126_ay}), 16).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((IItemProvider)Blocks.field_150432_aD, 4))).build();
        this.quest(Alignment.WINTER, "skull").parent("snowballs").task(QuestTask.of(ItemTask.INSTANCE, new IngredientStack(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196186_dz}), 1))).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((IItemProvider)Items.field_196183_dw))).build();
        this.quest(Alignment.WINTER, "lantern").parent("skull").task(QuestTask.of(CraftTask.INSTANCE, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_234790_rk_}))).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((IItemProvider)Items.field_151103_aS, 5))).build();
        this.quest(Alignment.WINTER, "sapling").parent("lantern").icon((IItemProvider)ModTrees.winterTree.getSapling()).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((IItemProvider)ModTrees.winterTree.getSapling(), 3))).build();
    }

    public void func_200398_a(@Nonnull DirectoryCache cache) throws IOException {
        this.setup();
        for (Alignment alignment : this.quests.keySet()) {
            HashSet<ResourceLocation> ids = new HashSet<ResourceLocation>();
            for (Quest quest : this.quests.get((Object)alignment)) {
                if (ids.contains(quest.id)) {
                    throw new IllegalStateException("Duplicate quest id: " + quest.id);
                }
                ids.add(quest.id);
            }
            for (Quest quest : this.quests.get((Object)alignment)) {
                for (ResourceLocation parent : quest.parents) {
                    if (ids.contains(parent)) continue;
                    throw new IllegalStateException("Reference to unknown quest: " + parent + " (in " + quest.id + ")");
                }
                IDataProvider.func_218426_a((Gson)DatapackHelper.GSON, (DirectoryCache)cache, (JsonElement)quest.toJson(), (Path)this.generator.func_200391_b().resolve("data").resolve(quest.id.func_110624_b()).resolve("feywild_quests").resolve(alignment.id).resolve(quest.id.func_110623_a() + ".json"));
            }
        }
    }

    @Nonnull
    public String func_200397_b() {
        return this.mod.modid + "quests";
    }

    public QuestBuilder root(Alignment alignment) {
        return this.quest(alignment, "root");
    }

    public QuestBuilder quest(Alignment alignment, String name) {
        return new QuestBuilder(alignment, name);
    }

    public class QuestBuilder {
        private final Alignment alignment;
        private final ResourceLocation id;
        private final Set<String> parents;
        private final List<QuestTask> tasks;
        private final List<QuestReward> rewards;
        private boolean repeatable = false;
        private int reputation;
        private Item icon;
        private QuestDisplay start;
        @Nullable
        private QuestDisplay complete;

        public QuestBuilder(Alignment alignment, String name) {
            this.alignment = alignment;
            this.id = new ResourceLocation(((QuestProvider)QuestProvider.this).mod.modid, name);
            this.parents = new HashSet<String>();
            this.reputation = 5;
            this.icon = null;
            this.start = new QuestDisplay((ITextComponent)new TranslationTextComponent("quest." + ((QuestProvider)QuestProvider.this).mod.modid + "." + alignment.id + "." + name + ".start.title"), (ITextComponent)new TranslationTextComponent("quest." + ((QuestProvider)QuestProvider.this).mod.modid + "." + alignment.id + "." + name + ".start.description"), null);
            this.complete = new QuestDisplay((ITextComponent)new TranslationTextComponent("quest." + ((QuestProvider)QuestProvider.this).mod.modid + "." + alignment.id + "." + name + ".complete.title"), (ITextComponent)new TranslationTextComponent("quest." + ((QuestProvider)QuestProvider.this).mod.modid + "." + alignment.id + "." + name + ".complete.description"), null);
            this.tasks = new ArrayList<QuestTask>();
            this.rewards = new ArrayList<QuestReward>();
        }

        public QuestBuilder parent(String ... ids) {
            this.parents.addAll(Arrays.asList(ids));
            return this;
        }

        public QuestBuilder repeatable() {
            this.repeatable = true;
            return this;
        }

        public QuestBuilder reputation(int reputation) {
            this.reputation = reputation;
            return this;
        }

        public QuestBuilder icon(IItemProvider icon) {
            this.icon = icon.func_199767_j();
            return this;
        }

        public QuestBuilder start(QuestDisplay display) {
            this.start = display;
            return this;
        }

        public QuestBuilder complete(@Nullable QuestDisplay display) {
            this.complete = display;
            return this;
        }

        public QuestBuilder startSound(@Nullable SoundEvent sound) {
            this.start = new QuestDisplay(this.start.title, this.start.description, sound);
            return this;
        }

        public QuestBuilder completeSound(@Nullable SoundEvent sound) {
            if (this.complete == null) {
                throw new IllegalStateException("Can't set sound on null completion.");
            }
            this.complete = new QuestDisplay(this.complete.title, this.complete.description, sound);
            return this;
        }

        public QuestBuilder task(QuestTask ... tasks) {
            this.tasks.addAll(Arrays.asList(tasks));
            return this;
        }

        public QuestBuilder gift(Ingredient ingredient) {
            return this.gift(ingredient, 1);
        }

        public QuestBuilder gift(Ingredient ingredient, int times) {
            this.tasks.add(QuestTask.of(FeyGiftTask.INSTANCE, new FeyGift(this.alignment, ingredient), times));
            return this;
        }

        public QuestBuilder reward(QuestReward ... rewards) {
            this.rewards.addAll(Arrays.asList(rewards));
            return this;
        }

        public void build() {
            Item icon = this.icon;
            if (this.icon == null && this.tasks.size() == 1) {
                icon = this.tasks.get(0).icon();
            }
            if (icon == null) {
                throw new IllegalStateException("Can't build quest without icon: " + this.id);
            }
            Set<ResourceLocation> parents = this.parents.stream().map(str -> new ResourceLocation(((QuestProvider)QuestProvider.this).mod.modid, str)).collect(Collectors.toSet());
            Quest quest = new Quest(this.id, parents, this.repeatable, this.reputation, icon, this.start, this.tasks.isEmpty() ? null : this.complete, this.tasks, this.rewards);
            QuestProvider.this.quests.computeIfAbsent(this.alignment, k -> new HashSet()).add(quest);
        }
    }
}

