/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity;

import com.feywild.feywild.entity.base.ITameable;
import com.feywild.feywild.entity.base.TraderEntity;
import com.feywild.feywild.entity.goals.DwarvenAttackGoal;
import com.feywild.feywild.entity.goals.GoToAnvilPositionGoal;
import com.feywild.feywild.entity.goals.GoToTargetPositionGoal;
import com.feywild.feywild.entity.goals.RefreshStockGoal;
import io.github.noeppi_noeppi.libx.util.NBTX;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DwarfBlacksmithEntity
extends TraderEntity
implements ITameable,
IAnimatable {
    public static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(DwarfBlacksmithEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final AnimationFactory animationFactory = new AnimationFactory((IAnimatable)this);
    private BlockPos summonPos;
    private boolean isTamed;

    public DwarfBlacksmithEntity(EntityType<? extends TraderEntity> type, World world) {
        super(type, world);
        this.field_70158_ak = true;
        this.field_70765_h = new MovementController((MobEntity)this);
    }

    public static AttributeModifierMap.MutableAttribute getDefaultAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, Attributes.field_233821_d_.func_111110_b()).func_233815_a_(Attributes.field_233818_a_, 36.0).func_233815_a_(Attributes.field_233820_c_, 0.8).func_233815_a_(Attributes.field_233827_j_, 5.0).func_233815_a_(Attributes.field_233826_i_, 15.0).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233821_d_, 0.35);
    }

    public static boolean canSpawn(EntityType<DwarfBlacksmithEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        if (pos.func_177956_o() >= world.func_181545_F() - 10 || world.func_226660_f_(pos) || random.nextDouble() < 0.15) {
            return false;
        }
        return DwarfBlacksmithEntity.func_223315_a(type, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)random);
    }

    @Override
    public String getTradeCategory() {
        return this.isTamed() ? "tamed" : "untamed";
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)0);
    }

    @Nonnull
    public ActionResultType func_184199_a(PlayerEntity player, @Nonnull Vector3d vec, @Nonnull Hand hand) {
        if (!player.func_130014_f_().field_72995_K) {
            this.trade(player);
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    protected void trade(PlayerEntity player) {
        this.func_70932_a_(player);
        this.func_213707_a(player, (ITextComponent)new TranslationTextComponent("Dwarven Trader"), 1);
        player.func_146105_b((ITextComponent)new TranslationTextComponent("dwarf.feywild.dialogue"), false);
    }

    @Nullable
    public ILivingEntityData func_213386_a(@Nonnull IServerWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataNbt) {
        this.func_213390_a(this.func_233580_cy_(), 7);
        return super.func_213386_a(world, difficulty, reason, spawnData, dataNbt);
    }

    public BlockPos getSummonPos() {
        return this.summonPos;
    }

    public void setSummonPos(BlockPos summonPos) {
        this.summonPos = summonPos.func_185334_h();
    }

    @Override
    public boolean isTamed() {
        return this.isTamed;
    }

    public void setTamed(boolean tamed) {
        this.isTamed = tamed;
    }

    public State getState() {
        State[] states = State.values();
        return states[MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state.ordinal());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, (double)0.1f, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)GoToTargetPositionGoal.byBlockPos((MobEntity)this, this::getSummonPos, 5, 0.5f));
        this.field_70714_bg.func_75776_a(2, (Goal)new GoToAnvilPositionGoal(this, this::getSummonPos, 5));
        this.field_70714_bg.func_75776_a(6, (Goal)new RefreshStockGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new DwarvenAttackGoal(this));
    }

    @Override
    public void func_213281_b(@Nonnull CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("Tamed", this.isTamed);
        if (this.summonPos != null) {
            NBTX.putPos((CompoundNBT)nbt, (String)"SummonPos", (BlockPos)this.summonPos);
        }
    }

    @Override
    public void func_70037_a(@Nonnull CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.isTamed = nbt.func_74767_n("Tamed");
        this.summonPos = NBTX.getPos((CompoundNBT)nbt, (String)"SummonPos", null);
    }

    public boolean func_213380_a(@Nonnull IWorld worldIn, @Nonnull SpawnReason spawnReasonIn) {
        return super.func_213380_a(worldIn, spawnReasonIn) && this.func_233580_cy_().func_177956_o() < 60 && !worldIn.func_226660_f_(this.func_233580_cy_());
    }

    protected void func_213385_F() {
        super.func_213385_F();
        this.field_70714_bg.func_220878_a(Goal.Flag.MOVE, true);
        this.field_70714_bg.func_220878_a(Goal.Flag.JUMP, true);
        this.field_70714_bg.func_220878_a(Goal.Flag.LOOK, true);
    }

    protected boolean func_184228_n(@Nonnull Entity entityIn) {
        return false;
    }

    public boolean func_213392_I() {
        return true;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected int func_70693_a(@Nonnull PlayerEntity player) {
        return 0;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_219721_mv;
    }

    protected float func_70647_i() {
        return 0.6f;
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (!this.field_70729_aU && !this.func_233643_dh_()) {
            if (this.getState() == State.ATTACKING) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dwarf_blacksmith.smash", Boolean.valueOf(false)));
                return PlayState.CONTINUE;
            }
            if (this.getState() == State.WORKING) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dwarf_blacksmith.craft", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dwarf_blacksmith.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dwarf_blacksmith.stand", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }

    public boolean func_104002_bU() {
        return this.isTamed || this.func_213708_dV() > 0 || super.func_104002_bU();
    }

    public void func_70623_bb() {
        if (!this.func_104002_bU()) {
            PlayerEntity entity = this.field_70170_p.func_217362_a((Entity)this, -1.0);
            Event.Result result = ForgeEventFactory.canEntityDespawn((MobEntity)this);
            if (result == Event.Result.DENY) {
                this.field_70708_bq = 0;
                entity = null;
            } else if (result == Event.Result.ALLOW) {
                this.func_70106_y();
                entity = null;
            }
            if (entity != null) {
                double distance = entity.func_70068_e((Entity)this);
                int k = this.func_200600_R().func_220339_d().func_233672_g_();
                int l = k * k;
                if (this.field_70708_bq > 2400 && this.field_70146_Z.nextInt(800) == 0 && distance > (double)l && this.func_213397_c(distance * 2.0)) {
                    this.func_70106_y();
                } else if (distance < (double)l) {
                    this.field_70708_bq = 0;
                }
            }
        } else {
            this.field_70708_bq = 0;
        }
    }

    public static enum State {
        IDLE,
        ATTACKING,
        WORKING;

    }
}

