/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.block.ModBlocks;
import com.feywild.feywild.entity.ModEntityTypes;
import com.feywild.feywild.entity.base.GroundFeyBase;
import com.feywild.feywild.entity.goals.GoToTargetPositionGoal;
import com.feywild.feywild.entity.goals.SingGoal;
import com.feywild.feywild.network.ParticleSerializer;
import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.sound.ModSoundEvents;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MandragoraEntity
extends GroundFeyBase
implements IAnimatable {
    public static final DataParameter<Boolean> CASTING = EntityDataManager.func_187226_a(MandragoraEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(MandragoraEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final double MIN_MOVING_SPEED_SQR = 0.0025000000000000005;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private boolean isTamed = false;

    public MandragoraEntity(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, Alignment.SPRING, world);
        this.field_70158_ak = true;
        this.field_70765_h = new MovementController((MobEntity)this);
        this.field_70180_af.func_187227_b(VARIANT, (Object)this.func_70681_au().nextInt(MandragoraVariant.values().length));
    }

    public static AttributeModifierMap.MutableAttribute getDefaultAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, Attributes.field_233821_d_.func_111110_b()).func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233821_d_, 0.1).func_233815_a_(Attributes.field_233828_k_, 0.2);
    }

    @Override
    public BasicParticleType getParticle() {
        return null;
    }

    public MandragoraVariant getVariation() {
        return MandragoraVariant.values()[(Integer)this.field_70180_af.func_187225_a(VARIANT)];
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(50, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, (double)0.2f, 4.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new GoToTargetPositionGoal((MobEntity)this, this::getCurrentPointOfInterest, 5, 0.2f));
        this.field_70714_bg.func_75776_a(10, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151106_aX}), false));
        this.field_70714_bg.func_75776_a(20, (Goal)new SingGoal(this));
    }

    @Override
    public void func_213281_b(@Nonnull CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("variant", ((Integer)this.field_70180_af.func_187225_a(VARIANT)).intValue());
    }

    @Override
    public void func_70037_a(@Nonnull CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("variant")) {
            this.field_70180_af.func_187227_b(VARIANT, (Object)nbt.func_74762_e("variant"));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CASTING, (Object)false);
        this.field_70180_af.func_187214_a(VARIANT, (Object)VARIANT.func_187155_a());
    }

    protected void func_213385_F() {
        super.func_213385_F();
        this.field_70714_bg.func_220878_a(Goal.Flag.MOVE, true);
        this.field_70714_bg.func_220878_a(Goal.Flag.JUMP, true);
        this.field_70714_bg.func_220878_a(Goal.Flag.LOOK, true);
    }

    public boolean isCasting() {
        return (Boolean)this.field_70180_af.func_187225_a(CASTING);
    }

    public void setCasting(boolean casting) {
        this.field_70180_af.func_187227_b(CASTING, (Object)casting);
    }

    @Override
    public boolean func_70617_f_() {
        return false;
    }

    @Override
    protected int func_225508_e_(float distance, float damageMultiplier) {
        return 0;
    }

    @Override
    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    @Override
    protected int func_70693_a(@Nonnull PlayerEntity player) {
        return 0;
    }

    @Override
    public boolean func_184652_a(@Nonnull PlayerEntity player) {
        return false;
    }

    @Override
    protected boolean func_184228_n(@Nonnull Entity entityIn) {
        return false;
    }

    @Override
    protected float func_70647_i() {
        return 1.0f;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSourceIn) {
        return ModSoundEvents.mandragoraHurt;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.mandragoraDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        return this.field_70146_Z.nextBoolean() ? ModSoundEvents.mandragoraAmbience : null;
    }

    @Nonnull
    public ActionResultType func_184199_a(@Nonnull PlayerEntity player, @Nonnull Vector3d hitVec, @Nonnull Hand hand) {
        if (!(player.func_184586_b(hand).func_77973_b() != Items.field_151106_aX || this.func_70643_av() != null && this.func_70643_av().func_70089_S())) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70691_i(4.0f);
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
                FeywildMod.getNetwork().sendParticles(this.field_70170_p, ParticleSerializer.Type.FEY_HEART, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                player.func_226292_a_(hand, true);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (!(player.func_184586_b(hand).func_77973_b() != ModBlocks.mandrakeCrop.getSeed() || this.func_70643_av() != null && this.func_70643_av().func_70089_S())) {
            MandragoraEntity entity = (MandragoraEntity)ModEntityTypes.mandragora.func_200721_a(this.field_70170_p);
            if (entity != null) {
                entity.setCurrentTargetPos(this.getCurrentPointOfInterest());
                entity.func_70107_b(this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b, this.func_213303_ch().field_72449_c);
                entity.setOwner(this.getOwner());
                this.field_70170_p.func_217376_c((Entity)entity);
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
                this.func_70106_y();
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_184199_a(player, hitVec, hand);
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (this.isCasting() && !this.field_70729_aU && !this.func_233643_dh_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mandragora.sing", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (this.func_213322_ci().func_189985_c() < 0.0025000000000000005) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mandragora.idle", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mandragora.walk", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean func_104002_bU() {
        return true;
    }

    public static enum MandragoraVariant {
        MELON,
        ONION,
        POTATO,
        PUMPKIN,
        TOMATO;

    }
}

