/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import com.feywild.feywild.entity.DwarfBlacksmithEntity;
import com.feywild.feywild.sound.ModSoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class DwarvenAttackGoal
extends Goal {
    protected final DwarfBlacksmithEntity entity;
    protected LivingEntity target;
    protected boolean sendShock = false;
    protected int ticksLeft = 0;

    public DwarvenAttackGoal(DwarfBlacksmithEntity entity) {
        this.entity = entity;
    }

    public void func_75246_d() {
        if (this.entity.func_70643_av() instanceof MonsterEntity) {
            this.target = this.entity.func_70643_av();
            --this.ticksLeft;
            if (this.ticksLeft == 0) {
                this.reset();
            } else if (this.ticksLeft == 10) {
                this.sendShock = this.attackTarget();
                this.entity.func_184185_a(ModSoundEvents.dwarfAttack, 1.0f, 1.2f);
                this.entity.setState(DwarfBlacksmithEntity.State.IDLE);
            } else if (this.ticksLeft == 30) {
                this.entity.setState(DwarfBlacksmithEntity.State.ATTACKING);
                this.entity.func_70661_as().func_75492_a(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_(), 0.5);
            } else if (this.ticksLeft <= 30) {
                this.entity.func_200602_a(EntityAnchorArgument.Type.EYES, this.target.func_213303_ch());
                if (this.sendShock) {
                    switch (this.ticksLeft) {
                        case 4: 
                        case 8: {
                            this.summonShockWave(true);
                            break;
                        }
                        case 6: {
                            this.summonShockWave(false);
                        }
                    }
                }
            }
        } else {
            this.reset();
        }
    }

    public void func_75249_e() {
        this.ticksLeft = 70;
    }

    protected boolean attackTarget() {
        if (this.entity.func_70681_au().nextDouble() > 0.6) {
            this.target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.entity), 15.0f);
            return false;
        }
        this.target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.entity), 20.0f);
        return true;
    }

    private void summonShockWave(boolean stage) {
        BlockPos centerPos = this.entity.func_233580_cy_().func_177977_b();
        int size = 2;
        ArrayList<FallingBlockEntity> entityList = new ArrayList<FallingBlockEntity>();
        for (int xd = 0; xd <= size; ++xd) {
            for (int zd = 0; zd <= size; ++zd) {
                int dist = Math.abs(xd) + Math.abs(zd);
                if (dist > size || this.entity.field_70170_p.func_180495_p(centerPos.func_177982_a(xd, -1, zd)).func_196958_f() || !this.entity.field_70170_p.func_180495_p(new BlockPos((Vector3i)centerPos.func_177982_a(xd, 0, zd))).func_196958_f() || xd == 0 && zd == 0) continue;
                if (stage) {
                    this.waveBlock(entityList, centerPos.func_177982_a(xd, 0, zd));
                    this.waveBlock(entityList, centerPos.func_177982_a(-xd, 0, -zd));
                    continue;
                }
                this.waveBlock(entityList, centerPos.func_177982_a(xd, 0, -zd));
                this.waveBlock(entityList, centerPos.func_177982_a(-xd, 0, zd));
            }
        }
        entityList.forEach(block -> {
            this.entity.func_184185_a(ModSoundEvents.dwarfAttack, 1.0f, 1.0f);
            block.func_213293_j(0.0, 0.3, 0.0);
            block.func_145806_a(true);
            this.entity.field_70170_p.func_217376_c((Entity)block);
        });
    }

    private void waveBlock(List<FallingBlockEntity> entityList, BlockPos pos) {
        BlockState state = this.entity.field_70170_p.func_180495_p(pos);
        if (!state.hasTileEntity() && state.func_185887_b((IBlockReader)this.entity.field_70170_p, pos) >= 0.0f) {
            entityList.add(new FallingBlockEntity(this.entity.field_70170_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, state));
        }
    }

    protected void reset() {
        this.entity.setState(DwarfBlacksmithEntity.State.IDLE);
        this.target = null;
        this.sendShock = false;
        this.ticksLeft = -1;
    }

    public boolean func_75253_b() {
        return this.ticksLeft > 0 && this.entity.func_70643_av() instanceof MobEntity && !this.entity.func_70643_av().func_190530_aW();
    }

    public boolean func_75250_a() {
        return this.entity.func_70643_av() instanceof MobEntity && !this.entity.func_70643_av().func_190530_aW() && this.entity.func_70685_l((Entity)this.entity.func_70643_av());
    }
}

