/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.network.quest;

import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.quest.util.SelectableQuest;
import com.google.common.collect.ImmutableList;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public class OpenQuestSelectionSerializer
implements PacketSerializer<Message> {
    public Class<Message> messageClass() {
        return Message.class;
    }

    public void encode(Message msg, PacketBuffer buffer) {
        buffer.func_179256_a(msg.title);
        buffer.func_179249_a((Enum)msg.alignment);
        buffer.func_150787_b(msg.quests.size());
        for (SelectableQuest quest : msg.quests) {
            quest.toNetwork(buffer);
        }
    }

    public Message decode(PacketBuffer buffer) {
        ITextComponent title = buffer.func_179258_d();
        Alignment alignment = (Alignment)buffer.func_179257_a(Alignment.class);
        int questSize = buffer.func_150792_a();
        ImmutableList.Builder quests = ImmutableList.builder();
        for (int i = 0; i < questSize; ++i) {
            quests.add((Object)SelectableQuest.fromNetwork(buffer));
        }
        return new Message(title, alignment, (List<SelectableQuest>)quests.build());
    }

    public static class Message {
        public final ITextComponent title;
        public final Alignment alignment;
        public final List<SelectableQuest> quests;

        public Message(ITextComponent title, Alignment alignment, List<SelectableQuest> quests) {
            this.title = title;
            this.alignment = alignment;
            this.quests = ImmutableList.copyOf(quests);
        }
    }
}

