/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.quest;

import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.quest.Quest;
import com.feywild.feywild.quest.QuestLine;
import com.feywild.feywild.util.DatapackHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;

public class QuestManager {
    private static Map<Alignment, QuestLine> questLines = ImmutableMap.of();

    public static QuestLine getQuests(Alignment alignment) {
        return questLines.getOrDefault((Object)alignment, QuestLine.EMPTY);
    }

    public static IFutureReloadListener createReloadListener() {
        return new ReloadListener<Void>(){

            @Nonnull
            protected Void prepare(@Nonnull IResourceManager rm, @Nonnull IProfiler profiler) {
                return null;
            }

            protected void apply(@Nonnull Void value, @Nonnull IResourceManager rm, @Nonnull IProfiler profiler) {
                EnumMap<Alignment, QuestLine> lines = new EnumMap<Alignment, QuestLine>(Alignment.class);
                for (Alignment alignment : Alignment.values()) {
                    lines.put(alignment, new QuestLine(DatapackHelper.loadData(rm, "feywild_quests/" + alignment.id, Quest::fromJson)));
                }
                questLines = Collections.unmodifiableMap(lines);
            }
        };
    }
}

