/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.trade.recipe;

import com.feywild.feywild.trade.TradeData;
import com.feywild.feywild.trade.TradeLevelData;
import com.feywild.feywild.trade.entries.CompoundTrade;
import com.feywild.feywild.trade.entries.SimpleTrade;
import com.feywild.feywild.trade.item.CompoundStackFactory;
import com.feywild.feywild.trade.item.SimpleStackFactory;
import com.feywild.feywild.trade.item.StackFactory;
import com.feywild.feywild.trade.recipe.TradeRecipe;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TradeRecipeManager {
    public static List<TradeRecipe> getRecipes(ResourceLocation id, TradeData data) {
        ImmutableList.Builder recipe = ImmutableList.builder();
        for (int i = 1; i <= data.getMaxLevel(); ++i) {
            recipe.add((Object)TradeRecipeManager.getRecipe(id, i, data.getLevel(i)));
        }
        return recipe.build();
    }

    private static TradeRecipe getRecipe(ResourceLocation id, int level, TradeLevelData data) {
        List<TradeRecipe.Entry> trades = data.getAllTrades().stream().flatMap(TradeRecipeManager::expandTrades).collect(Collectors.toList());
        return new TradeRecipe(id, level, trades);
    }

    private static Stream<TradeRecipe.Entry> expandTrades(VillagerTrades.ITrade trade) {
        if (trade instanceof SimpleTrade) {
            return Stream.of(TradeRecipeManager.expandSimpleTrade((SimpleTrade)trade));
        }
        if (trade instanceof CompoundTrade) {
            return ((CompoundTrade)trade).trades.stream().flatMap(TradeRecipeManager::expandTrades);
        }
        return Stream.empty();
    }

    private static TradeRecipe.Entry expandSimpleTrade(SimpleTrade trade) {
        List<ItemStack> input = TradeRecipeManager.expandFactory(trade.input).collect(Collectors.toList());
        List<ItemStack> additional = TradeRecipeManager.expandFactory(trade.additional).collect(Collectors.toList());
        List<ItemStack> output = TradeRecipeManager.expandFactory(trade.output).collect(Collectors.toList());
        return new TradeRecipe.Entry(input, additional, output);
    }

    private static Stream<ItemStack> expandFactory(StackFactory factory) {
        if (factory instanceof SimpleStackFactory) {
            return Stream.of(((SimpleStackFactory)factory).getStack());
        }
        if (factory instanceof CompoundStackFactory) {
            return ((CompoundStackFactory)factory).factories.stream().flatMap(TradeRecipeManager::expandFactory);
        }
        return Stream.empty();
    }
}

