/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.block.ModTrees;
import com.feywild.feywild.block.trees.BaseTree;
import com.feywild.feywild.config.CompatConfig;
import com.feywild.feywild.config.MobConfig;
import com.feywild.feywild.config.WorldGenConfig;
import com.feywild.feywild.entity.ModEntityTypes;
import com.feywild.feywild.world.AlfheimCompat;
import com.feywild.feywild.world.feature.ModConfiguredFeatures;
import com.feywild.feywild.world.gen.OreType;
import com.feywild.feywild.world.structure.ModConfiguredStructures;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class BiomeLoader {
    public static final ResourceLocation SPRING_BIOME = new ResourceLocation(FeywildMod.getInstance().modid, "blossoming_wealds");
    public static final ResourceLocation SUMMER_BIOME = new ResourceLocation(FeywildMod.getInstance().modid, "golden_seelie_fields");
    public static final ResourceLocation AUTUMN_BIOME = new ResourceLocation(FeywildMod.getInstance().modid, "eternal_fall");
    public static final ResourceLocation WINTER_BIOME = new ResourceLocation(FeywildMod.getInstance().modid, "frozen_retreat");
    public static final ResourceLocation SPRING_ALFHEIM = new ResourceLocation(FeywildMod.getInstance().modid, "alfheim_spring");
    public static final ResourceLocation SUMMER_ALFHEIM = new ResourceLocation(FeywildMod.getInstance().modid, "alfheim_summer");
    public static final ResourceLocation AUTUMN_ALFHEIM = new ResourceLocation(FeywildMod.getInstance().modid, "alfheim_autumn");
    public static final ResourceLocation WINTER_ALFHEIM = new ResourceLocation(FeywildMod.getInstance().modid, "alfheim_winter");
    public static final ResourceLocation MUSHROOM_FIELDS = new ResourceLocation("minecraft", "mushroom_fields");
    public static final ResourceLocation MUSHROOM_SHORE = new ResourceLocation("minecraft", "mushroom_field_shore");
    public static final Set<ResourceLocation> IGNORED_BIOMES = ImmutableSet.of((Object)new ResourceLocation("bingolobby", "lobby"));
    public static final Set<ResourceLocation> SEASONAL_BIOMES = ImmutableSet.of((Object)SPRING_BIOME, (Object)SUMMER_BIOME, (Object)AUTUMN_BIOME, (Object)WINTER_BIOME);
    public static final Set<ResourceLocation> ALFHEIM_BIOMES = ImmutableSet.of((Object)SPRING_ALFHEIM, (Object)SUMMER_ALFHEIM, (Object)AUTUMN_ALFHEIM, (Object)WINTER_ALFHEIM);
    public static final Set<ResourceLocation> WHITELIST_BIOMES = MobConfig.dimensions.white_list_biomes;

    public static void loadBiome(BiomeLoadingEvent event) {
        Random random = new Random();
        ResourceLocation biomeId = event.getName();
        if (biomeId == null || IGNORED_BIOMES.contains(biomeId)) {
            return;
        }
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biomeId);
        Set types = BiomeDictionary.getTypes((RegistryKey)key);
        BiomeLoader.ores(event, biomeId, types, random);
        BiomeLoader.treePatches(event, biomeId, types, random);
        BiomeLoader.feywildBiomes(event, biomeId, types, random);
        BiomeLoader.mobSpawns(event, biomeId, types, random);
        BiomeLoader.commonStructures(event, biomeId, types, random);
    }

    private static void ores(BiomeLoadingEvent event, ResourceLocation biomeId, Set<BiomeDictionary.Type> types, Random random) {
        for (OreType ore : OreType.values()) {
            if (!(CompatConfig.mythic_alfheim.locked || event.getCategory().equals((Object)Biome.Category.NETHER) || event.getCategory().equals((Object)Biome.Category.THEEND))) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ore.getFeature());
            }
            if (!CompatConfig.mythic_alfheim.alfheim || !AlfheimCompat.isAlfheim(types)) continue;
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ore.getAlfheimFeature());
        }
    }

    private static void treePatches(BiomeLoadingEvent event, ResourceLocation biomeId, Set<BiomeDictionary.Type> types, Random random) {
        if (types.contains(BiomeDictionary.Type.OVERWORLD)) {
            if ((types.contains(BiomeDictionary.Type.PLAINS) || types.contains(BiomeDictionary.Type.RIVER) || types.contains(BiomeDictionary.Type.FOREST)) && !types.contains(BiomeDictionary.Type.MAGICAL) && WorldGenConfig.tree_patches.spring) {
                BiomeLoader.addLooseTrees(event, ModTrees.springTree, random, types.contains(BiomeDictionary.Type.FOREST));
            }
            if ((types.contains(BiomeDictionary.Type.HOT) || types.contains(BiomeDictionary.Type.LUSH)) && !types.contains(BiomeDictionary.Type.MAGICAL) && WorldGenConfig.tree_patches.summer) {
                BiomeLoader.addLooseTrees(event, ModTrees.summerTree, random, false);
            }
            if ((types.contains(BiomeDictionary.Type.SWAMP) || types.contains(BiomeDictionary.Type.MUSHROOM) || types.contains(BiomeDictionary.Type.SPOOKY)) && !types.contains(BiomeDictionary.Type.MAGICAL) && WorldGenConfig.tree_patches.autumn) {
                BiomeLoader.addLooseTrees(event, ModTrees.autumnTree, random, false);
            }
            if ((types.contains(BiomeDictionary.Type.DEAD) || types.contains(BiomeDictionary.Type.SNOWY) || types.contains(BiomeDictionary.Type.COLD)) && !types.contains(BiomeDictionary.Type.MAGICAL) && WorldGenConfig.tree_patches.winter) {
                BiomeLoader.addLooseTrees(event, ModTrees.winterTree, random, false);
            }
        }
    }

    private static void addLooseTrees(BiomeLoadingEvent event, BaseTree tree, Random random, boolean isForest) {
        event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, tree.func_225546_b_(random, true).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, (float)(isForest ? 2 : 1) * WorldGenConfig.tree_patches.chance, WorldGenConfig.tree_patches.size))));
    }

    private static void feywildBiomes(BiomeLoadingEvent event, ResourceLocation biomeId, Set<BiomeDictionary.Type> types, Random random) {
        if (SPRING_BIOME.equals((Object)biomeId) || SPRING_ALFHEIM.equals((Object)biomeId) && CompatConfig.mythic_alfheim.alfheim) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.SPRING_TREES);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.SPRING_DANDELION);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.SPRING_FLOWERS);
        }
        if (SUMMER_BIOME.equals((Object)biomeId) || SUMMER_ALFHEIM.equals((Object)biomeId) && CompatConfig.mythic_alfheim.alfheim) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.SUMMER_TREES);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.SUMMER_SUNFLOWER);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.SUMMER_WARM_FLOWERS);
        }
        if (AUTUMN_BIOME.equals((Object)biomeId) || AUTUMN_ALFHEIM.equals((Object)biomeId) && CompatConfig.mythic_alfheim.alfheim) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.AUTUMN_TREES);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.AUTUMN_PUMPKINS);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.AUTUMN_SWAMP_FLOWERS);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.AUTUMN_SMALL_MUSHROOMS);
        }
        if (WINTER_BIOME.equals((Object)biomeId) || WINTER_ALFHEIM.equals((Object)biomeId) && CompatConfig.mythic_alfheim.alfheim) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.WINTER_TREES);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.WINTER_CROCUS);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.WINTER_FLOWERS);
        }
    }

    private static void mobSpawns(BiomeLoadingEvent event, ResourceLocation biomeId, Set<BiomeDictionary.Type> types, Random random) {
        if (CompatConfig.mythic_alfheim.locked) {
            if (SPRING_ALFHEIM.equals((Object)biomeId)) {
                BiomeLoader.addSpawn(event, ModEntityTypes.springPixie, EntityClassification.CREATURE, MobConfig.spring_pixie.weight, MobConfig.spring_pixie.min, MobConfig.spring_pixie.max);
            }
            if (SUMMER_ALFHEIM.equals((Object)biomeId)) {
                BiomeLoader.addSpawn(event, ModEntityTypes.summerPixie, EntityClassification.CREATURE, MobConfig.summer_pixie.weight, MobConfig.summer_pixie.min, MobConfig.summer_pixie.max);
                BiomeLoader.addSpawn(event, ModEntityTypes.beeKnight, EntityClassification.CREATURE, MobConfig.summer_bee_knight.weight, MobConfig.summer_bee_knight.min, MobConfig.summer_bee_knight.max);
            }
            if (AUTUMN_ALFHEIM.equals((Object)biomeId)) {
                BiomeLoader.addSpawn(event, ModEntityTypes.autumnPixie, EntityClassification.CREATURE, MobConfig.autumn_pixie.weight, MobConfig.autumn_pixie.min, MobConfig.autumn_pixie.max);
            }
            if (WINTER_ALFHEIM.equals((Object)biomeId)) {
                BiomeLoader.addSpawn(event, ModEntityTypes.winterPixie, EntityClassification.CREATURE, MobConfig.winter_pixie.weight, MobConfig.winter_pixie.min, MobConfig.winter_pixie.max);
            }
        } else if (types.contains(BiomeDictionary.Type.OVERWORLD) && !types.contains(BiomeDictionary.Type.OCEAN) || WHITELIST_BIOMES.contains(biomeId)) {
            if (!MUSHROOM_FIELDS.equals((Object)biomeId) && !MUSHROOM_SHORE.equals((Object)biomeId)) {
                BiomeLoader.addSpawn(event, ModEntityTypes.dwarfBlacksmith, EntityClassification.MONSTER, MobConfig.dwarf_blacksmith.weight, MobConfig.dwarf_blacksmith.min, MobConfig.dwarf_blacksmith.max);
            }
            BiomeLoader.addAdvancedSpawns(event, biomeId, ModEntityTypes.springPixie, SPRING_BIOME, SPRING_ALFHEIM, types, MobConfig.spring_pixie.biomes, MobConfig.spring_pixie.weight, MobConfig.spring_pixie.min, MobConfig.spring_pixie.max);
            BiomeLoader.addAdvancedSpawns(event, biomeId, ModEntityTypes.summerPixie, SUMMER_BIOME, SUMMER_ALFHEIM, types, MobConfig.summer_pixie.biomes, MobConfig.summer_pixie.weight, MobConfig.summer_pixie.min, MobConfig.summer_pixie.max);
            BiomeLoader.addAdvancedSpawns(event, biomeId, ModEntityTypes.autumnPixie, AUTUMN_BIOME, AUTUMN_ALFHEIM, types, MobConfig.autumn_pixie.biomes, MobConfig.autumn_pixie.weight, MobConfig.autumn_pixie.min, MobConfig.autumn_pixie.max);
            BiomeLoader.addAdvancedSpawns(event, biomeId, ModEntityTypes.winterPixie, WINTER_BIOME, WINTER_ALFHEIM, types, MobConfig.winter_pixie.biomes, MobConfig.winter_pixie.weight, MobConfig.winter_pixie.min, MobConfig.winter_pixie.max);
            BiomeLoader.addAdvancedSpawns(event, biomeId, ModEntityTypes.shroomling, AUTUMN_BIOME, AUTUMN_ALFHEIM, types, MobConfig.shroomling.biomes, MobConfig.shroomling.weight, MobConfig.shroomling.min, MobConfig.shroomling.max);
        }
    }

    private static void addAdvancedSpawns(BiomeLoadingEvent event, ResourceLocation biomeId, EntityType<?> type, ResourceLocation targetBiome, ResourceLocation targetAlfheim, Set<BiomeDictionary.Type> types, List<BiomeDictionary.Type> targetBiomes, int weight, int min, int max) {
        boolean targeted = targetBiome.equals((Object)biomeId) || targetAlfheim.equals((Object)biomeId);
        boolean seasonalOverworld = SEASONAL_BIOMES.contains(biomeId);
        boolean seasonalAlfheim = ALFHEIM_BIOMES.contains(biomeId);
        boolean seasonal = seasonalOverworld || seasonalAlfheim;
        boolean regularAlfheim = !seasonalAlfheim && AlfheimCompat.isAlfheim(types);
        for (BiomeDictionary.Type biomeTag : targetBiomes) {
            boolean tagged = types.contains(biomeTag);
            if ((!types.contains(biomeTag) || !targeted && seasonal) && !regularAlfheim) continue;
            BiomeLoader.addSpawn(event, type, EntityClassification.CREATURE, targeted ? 2 * weight : weight, min, max);
        }
    }

    private static void addSpawn(BiomeLoadingEvent event, EntityType<?> type, EntityClassification classification, int weight, int min, int max) {
        event.getSpawns().getSpawner(classification).add(new MobSpawnInfo.Spawners(type, weight, min, max));
    }

    private static void commonStructures(BiomeLoadingEvent event, ResourceLocation biomeId, Set<BiomeDictionary.Type> types, Random random) {
        if (!types.contains(BiomeDictionary.Type.OCEAN) && types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.PLAINS)) {
            event.getGeneration().func_242516_a(ModConfiguredStructures.CONFIGURED_BLACKSMITH);
            event.getGeneration().func_242516_a(ModConfiguredStructures.CONFIGURED_LIBRARY);
        }
    }
}

