/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.biome;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingSurfaceBuilder<C extends ISurfaceBuilderConfig, S extends SurfaceBuilder<C>>
extends SurfaceBuilder<C> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Lazy<S> delegatedSurfaceBuilder;
    private boolean logged = false;

    public LoggingSurfaceBuilder(Supplier<S> delegatedSurfaceBuilder, Codec<C> codec) {
        super(codec);
        this.delegatedSurfaceBuilder = Lazy.of(delegatedSurfaceBuilder);
    }

    public void func_205610_a_(@Nonnull Random random, @Nonnull IChunk chunkIn, @Nonnull Biome biomeIn, int x, int z, int startHeight, double noise, @Nonnull BlockState defaultBlock, @Nonnull BlockState defaultFluid, int seaLevel, long seed, @Nonnull C config) {
        ((SurfaceBuilder)this.delegatedSurfaceBuilder.get()).func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, config);
        if (!this.logged && !FMLEnvironment.production) {
            this.logged = true;
            ChunkPos chunkPos = chunkIn.func_76632_l();
            LOGGER.info("Currently Generated at {} at {}, {}", (Object)biomeIn.getRegistryName(), (Object)chunkPos.func_180334_c(), (Object)chunkPos.func_180333_d());
        }
    }
}

