/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.biome;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.world.biome.biomes.AutumnBiome;
import com.feywild.feywild.world.biome.biomes.BiomeEnvironment;
import com.feywild.feywild.world.biome.biomes.BiomeFactory;
import com.feywild.feywild.world.biome.biomes.BiomeType;
import com.feywild.feywild.world.biome.biomes.SpringBiome;
import com.feywild.feywild.world.biome.biomes.SummerBiome;
import com.feywild.feywild.world.biome.biomes.WinterBiome;
import com.feywild.feywild.world.structure.ModStructures;
import mythicbotany.ModEntities;
import mythicbotany.alfheim.AlfheimBiomeManager;
import mythicbotany.alfheim.AlfheimBiomes;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class ModAlfheimBiomes {
    public static final BiomeEnvironment ALFHEIM = new BiomeEnvironment(){

        @Override
        public Biome.Builder init() {
            return AlfheimBiomes.alfheimBiome();
        }

        @Override
        public BiomeAmbience.Builder defaultAmbience() {
            return AlfheimBiomes.alfheimAmbience();
        }

        @Override
        public MobSpawnInfo.Builder defaultSpawns() {
            MobSpawnInfo.Builder builder = new MobSpawnInfoBuilder(MobSpawnInfo.field_242551_b).func_242572_a(0.4f);
            return builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.alfPixie, 50, 4, 10)).func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 2, 1, 2)).func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200764_D, 1, 1, 1));
        }

        @Override
        public BiomeGenerationSettings.Builder defaultGeneration(ConfiguredSurfaceBuilder<?> surface) {
            return AlfheimBiomes.alfheimGen(surface);
        }

        @Override
        public void postProcess(BiomeAmbience.Builder builder, BiomeType biome) {
            builder.func_235246_b_(4445678);
            builder.func_235248_c_(270131);
            builder.func_235239_a_(12638463);
        }
    };
    public static final Biome alfheimSpring = BiomeFactory.create(ALFHEIM, SpringBiome.INSTANCE);
    public static final Biome alfheimSummer = BiomeFactory.create(ALFHEIM, SummerBiome.INSTANCE);
    public static final Biome alfheimAutumn = BiomeFactory.create(ALFHEIM, AutumnBiome.INSTANCE);
    public static final Biome alfheimWinter = BiomeFactory.create(ALFHEIM, WinterBiome.INSTANCE);

    public static void register() {
        FeywildMod.getInstance().register("alfheim_spring", alfheimSpring);
        FeywildMod.getInstance().register("alfheim_summer", alfheimSummer);
        FeywildMod.getInstance().register("alfheim_autumn", alfheimAutumn);
        FeywildMod.getInstance().register("alfheim_winter", alfheimWinter);
    }

    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AlfheimBiomeManager.addUncommonBiome((ResourceLocation)alfheimSpring.getRegistryName());
            AlfheimBiomeManager.addUncommonBiome((ResourceLocation)alfheimSummer.getRegistryName());
            AlfheimBiomeManager.addUncommonBiome((ResourceLocation)alfheimAutumn.getRegistryName());
            AlfheimBiomeManager.addUncommonBiome((ResourceLocation)alfheimWinter.getRegistryName());
            AlfheimBiomeManager.addStructure((Structure)ModStructures.springWorldTree, (StructureSeparationSettings)ModStructures.springWorldTree.getSettings());
            AlfheimBiomeManager.addStructure((Structure)ModStructures.summerWorldTree, (StructureSeparationSettings)ModStructures.summerWorldTree.getSettings());
            AlfheimBiomeManager.addStructure((Structure)ModStructures.autumnWorldTree, (StructureSeparationSettings)ModStructures.autumnWorldTree.getSettings());
            AlfheimBiomeManager.addStructure((Structure)ModStructures.winterWorldTree, (StructureSeparationSettings)ModStructures.winterWorldTree.getSettings());
            AlfheimBiomeManager.addStructure((Structure)ModStructures.beekeep, (StructureSeparationSettings)ModStructures.beekeep.getSettings());
        });
    }
}

