/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.biome.biomes;

import com.feywild.feywild.config.MobConfig;
import com.feywild.feywild.config.WorldGenConfig;
import com.feywild.feywild.entity.ModEntityTypes;
import com.feywild.feywild.world.biome.ModConfiguredSurfaceBuilders;
import com.feywild.feywild.world.biome.biomes.BiomeType;
import com.feywild.feywild.world.structure.ModConfiguredStructures;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.BiomeMaker;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;

public class AutumnBiome
implements BiomeType {
    public static final AutumnBiome INSTANCE = new AutumnBiome();

    private AutumnBiome() {
    }

    @Override
    public Biome.Category category() {
        return Biome.Category.MUSHROOM;
    }

    @Override
    public float scale() {
        return WorldGenConfig.biomes.autumn.size;
    }

    @Override
    public float temperature() {
        return 0.8f;
    }

    @Override
    public float downfall() {
        return 0.9f;
    }

    @Override
    public ConfiguredSurfaceBuilder<?> surface() {
        return ModConfiguredSurfaceBuilders.AUTUMN_SURFACE;
    }

    @Override
    public void ambience(BiomeAmbience.Builder builder) {
        builder.func_235246_b_(6388580);
        builder.func_235248_c_(2302743);
        builder.func_235239_a_(12638463);
        builder.func_242539_d(BiomeMaker.func_244206_a((float)0.8f));
        builder.func_242540_e(6975545);
        builder.func_235244_a_(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_197607_R, 0.001f));
        builder.func_242537_a(BiomeAmbience.GrassColorModifier.SWAMP);
    }

    @Override
    public void spawns(MobSpawnInfo.Builder builder) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_220356_B, 20, 2, 3));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntityTypes.autumnPixie, 2 * MobConfig.autumn_pixie.weight, MobConfig.autumn_pixie.min, MobConfig.autumn_pixie.max));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntityTypes.shroomling, 2 * MobConfig.shroomling.weight, MobConfig.shroomling.min, MobConfig.shroomling.max));
    }

    @Override
    public void generation(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243852_ay);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243805_aD);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243810_aI);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243813_aL);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243965_y);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243861_bG);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243860_bF);
        DefaultBiomeFeatures.func_243703_Q((BiomeGenerationSettings.Builder)builder);
        builder.func_242516_a(ModConfiguredStructures.CONFIGURED_AUTUMN_WORLD_TREE);
    }

    @Override
    public void overworldSpawns(MobSpawnInfo.Builder builder) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200736_ab, 20, 4, 4));
        builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 50, 1, 3));
    }

    @Override
    public void overworldGen(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(StructureFeatures.field_244144_j);
    }
}

