/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.biome.biomes;

import com.feywild.feywild.config.MobConfig;
import com.feywild.feywild.config.WorldGenConfig;
import com.feywild.feywild.entity.ModEntityTypes;
import com.feywild.feywild.world.biome.ModConfiguredSurfaceBuilders;
import com.feywild.feywild.world.biome.biomes.BiomeType;
import com.feywild.feywild.world.structure.ModConfiguredStructures;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.BiomeMaker;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;

public class WinterBiome
implements BiomeType {
    public static final WinterBiome INSTANCE = new WinterBiome();

    private WinterBiome() {
    }

    @Override
    public Biome.Category category() {
        return Biome.Category.ICY;
    }

    @Override
    public Biome.RainType rain() {
        return Biome.RainType.SNOW;
    }

    @Override
    public float scale() {
        return WorldGenConfig.biomes.winter.size;
    }

    @Override
    public float temperature() {
        return 0.0f;
    }

    @Override
    public float downfall() {
        return 0.5f;
    }

    @Override
    public ConfiguredSurfaceBuilder<?> surface() {
        return ModConfiguredSurfaceBuilders.WINTER_SURFACE;
    }

    @Override
    public void ambience(BiomeAmbience.Builder builder) {
        builder.func_235246_b_(4159204);
        builder.func_235248_c_(329011);
        builder.func_235239_a_(12638463);
        builder.func_242539_d(BiomeMaker.func_244206_a((float)0.0f));
        builder.func_235244_a_(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_197622_o, 0.001f));
    }

    @Override
    public void spawns(MobSpawnInfo.Builder builder) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200786_Z, 10, 1, 2));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntityTypes.winterPixie, 2 * MobConfig.winter_pixie.weight, MobConfig.winter_pixie.min, MobConfig.winter_pixie.max));
    }

    @Override
    public void generation(BiomeGenerationSettings.Builder builder) {
        DefaultBiomeFeatures.func_243758_r((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243759_s((BiomeGenerationSettings.Builder)builder);
        builder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Features.field_243777_C);
        builder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Features.field_243778_D);
        builder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Features.field_243836_ai);
        builder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Features.field_243799_Y);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243876_bV);
        DefaultBiomeFeatures.func_243709_W((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243728_al((BiomeGenerationSettings.Builder)builder);
        builder.func_242516_a(ModConfiguredStructures.CONFIGURED_WINTER_WORLD_TREE);
    }

    @Override
    public void overworldSpawns(MobSpawnInfo.Builder builder) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200781_U, 5, 1, 1));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200724_aC, 10, 3, 4));
        builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200727_aF, 50, 3, 5));
    }

    @Override
    public void overworldGen(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(StructureFeatures.field_244141_g);
    }
}

